<?php
/*
 * @copyright Copyright (c) 2022 AltumCode (https://altumcode.com/)
 *
 * This software is exclusively sold through https://altumcode.com/ by the AltumCode author.
 * Downloading this product from any other sources and running it without a proper license is illegal,
 *  except the official ones linked from https://altumcode.com/.
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose Language',
    'global.theme_style' => 'Switch to %s Mode',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available..',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website Logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha Field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.status' => 'Status',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.all' => 'All',
    'global.filters.results_per_page' => 'Results per page',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and you are ready,<br /><br />you just need to click the following link in order to join {{WEBSITE_TITLE}}<br /><br /><a href="{{ACTIVATION_LINK}}">Activate your account</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}">Confirm email address change</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is your reset password link: <a href="{{LOST_PASSWORD_LINK}}">Reset Password</a><br /><br />If you did not request this, you can ignore it!<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />Your account plan is now paid until {{PLAN_EXPIRATION_DATE}}!<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your {{PLAN_NAME}} plan is going to expire in {{DAYS_UNTIL_EXPIRATION}} days.<br /><br />Please <a href="{{USER_PLAN_RENEW_LINK}}">renew your plan</a> if you wish to continue using our website with all the features you have.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply <a href="{{LOGIN_LINK}}">login</a> with your account and the deletion process will be stopped.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to <a href="{{REGISTER_LINK}}">register</a> another account with us.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM_NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',
    'global.emails.team_member_create.body_register' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'A new user just registered to the website!<br /><br />Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'A user just deleted his account from the website!<br /><br />All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',

    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent. <button type="button" data-cc="c-settings" class="cc-link">Let me choose</button>',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.save' => 'Save settings',
    'global.cookie_consent.close' => 'Close',

    'global.footer.copyright' => 'Copyright &copy; %1$s %2$s.',

    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.no_ads' => 'No Ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'statistics_reset_modal.header' => 'Reset statistics',
    'statistics_reset_modal.subheader' => 'Reset the current selected statistics. This action cannot be undone.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',


    'blog.title' => 'Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.subheader' => 'Get to learn & understand new things with the help of curated your blog posts.',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.menu' => 'Pricing',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew or change your plan',
    'plan.subheader_renew' => 'Select one plan to renew or change your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one package to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plan.button.choose' => 'Choose plan',
    'plan.button.renew' => 'Renew plan',
    'plan.button.trial' => 'Try for %s days',
    'plan.button.contact' => 'Contact us',

    'plan.why.header' => 'Why us?',
    'plan.why.subheader' => '',

    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our product.',

    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'We appreciate you and your privacy. This is why you control all the data that you bring with an account on our website.',

    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'FAQ',
    'plan.faq.subheader' => 'Here are the top most asked questions and their straight forward answers.',

    'plan.faq.one.header' => 'What forms of payment do you accept?',
    'plan.faq.one.text' => 'We accept payments via credit cards, PayPal & crypto as well.',

    'plan.faq.two.header' => 'Can I cancel my subscription?',
    'plan.faq.two.text' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',

    'plan.faq.three.header' => 'Will I get an invoice?',
    'plan.faq.three.text' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',

    'plan.faq.four.header' => 'Can I have a refund?',
    'plan.faq.four.text' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',

    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',

    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly Payments',
    'pay.custom_plan.annual' => 'Annual Payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'I have a discount/redeemable code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One Time Payment',
    'pay.custom_plan.recurring_type' => 'Recurring Payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid..',
    'pay.error_message.code_used' => 'You have already used this code..',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s Plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade Plan',
    'account.plan.renew_plan' => 'Renew/Change Plan',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Basic profile settings of your account.',
    'account.settings.email' => 'Email',
    'account.settings.name' => 'Name',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',


    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.city' => 'City',
    'account.billing.county' => 'County',
    'account.billing.country' => 'Country',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR code',
    'account.twofa.qr_help' => 'Open the authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the following QR code with your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR code?',
    'account.twofa.secret_help' => 'Try inserting the following secret code into your app if you can\'t scan the QR code.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, please enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid, please try again to setup the Two-factor authentication system.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',

    'account_plan.cancel.header' => 'Cancel Subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel Subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',

    'account_payments.title' => 'Account Payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account Payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payments.customer' => 'Customer',
    'account_payments.payments.type' => 'Type',
    'account_payments.payments.date' => 'Date',
    'account_payments.payments.name' => 'Full Name',
    'account_payments.payments.total_amount' => 'Total Amount',
    'account_payments.payments.plan_id' => 'Plan',
    'account_payments.payments.invoice' => 'Invoice',
    'account_payments.payments.status_pending' => 'Pending approval',
    'account_payments.payments.status_approved' => 'Approved',
    'account_payments.payments.no_data' => 'No payments for now..',

    'account_payments.filters.processor' => 'Processor',
    'account_payments.filters.type' => 'Type',
    'account_payments.filters.type_one_time' => 'One time',
    'account_payments.filters.type_recurring' => 'Recurring',
    'account_payments.filters.frequency' => 'Frequency',
    'account_payments.filters.frequency_monthly' => 'Monthly',
    'account_payments.filters.frequency_annual' => 'Annual',
    'account_payments.filters.frequency_lifetime' => 'Lifetime',
    'account_payments.filters.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.type' => 'Type',
    'account_logs.logs.ip' => 'IP',
    'account_logs.logs.details' => 'Details',
    'account_logs.logs.no_data' => 'Your account has no recorded logs..',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams system',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.input.name' => 'Name',
    'teams.table.members' => 'Members',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.input.user_email' => 'Email',
    'team_members.input.access' => 'Access',
    'team_members.input.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.input.access.all' => 'All',
    'team_members.input.access.read' => 'View',
    'team_members.input.access.create' => 'Create',
    'team_members.input.access.update' => 'Update',
    'team_members.input.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status' => 'Status',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited on',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams member',
    'teams_member.menu' => 'Teams member',
    'teams_member.breadcrumb' => 'Teams member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited on',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',
    'referrals.invite.button' => 'Copy referral link',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid' => 'Status',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'INVOICE',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.city' => 'City',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.country' => 'Country',
    'invoice.email' => 'Email',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.table.item' => 'Item',
    'invoice.table.amount' => 'Amount',
    'invoice.table.plan' => '%s Plan',
    'invoice.table.frequency' => '%s access.',
    'invoice.table.frequency_monthly' => '30 days',
    'invoice.table.frequency_annual' => '1 year',
    'invoice.table.frequency_lifetime' => 'Lifetime',
    'invoice.table.code' => 'Discount',
    'invoice.table.code_help' => 'Code used: %s',
    'invoice.table.total' => 'Total',
    'invoice.table.paid_via' => 'Paid via %s',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',

    'login.form.email' => 'Email',
    'login.form.password' => 'Password',
    'login.form.twofa_token' => 'Two-factor token',
    'login.form.remember_me' => 'Remember me',
    'login.form.login' => 'Login',
    'login.form.verify' => 'Verify',

    'login.display.register' => 'Don\'t have an account? %s',
    'login.display.register_help' => 'Register',
    'login.display.lost_password' => 'Lost Password',
    'login.display.resend_activation' => 'Resend Activation',
    'login.display.facebook' => 'Facebook Login',
    'login.display.google' => 'Google Login',
    'login.display.twitter' => 'Twitter Login',
    'login.display.discord' => 'Discord Login',

    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.email' => 'Email',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.email' => 'Email',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',

    'register.form.name' => 'Name',
    'register.form.email' => 'Email',
    'register.form.password' => 'Password',
    'register.form.repeat_password' => 'Repeat Password',
    'register.form.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.form.register' => 'Register',

    'register.display.login' => 'Already have an account? %s',
    'register.display.login_help' => 'Sign in',

    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'Check your email for the activation link of your account.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.view_all' => 'View all',
    'dashboard.qr_codes_header' => 'Latest QR codes',
    'dashboard.total_qr_codes' => '%s QR codes',
    'dashboard.total_links' => '%s Links',
    'dashboard.total_projects' => '%s projects',
    'dashboard.total_pixels' => '%s pixels',
    'dashboard.total_domains' => '%s domains',


    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'Online Web Tools',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'Online Web Tools',
    'index.subheader' => 'Choose from over 425+ quick & easy to use web tools.',
    'index.register' => 'Sign up',
    'index.tools' => 'Use tools',

    'index.pricing.header' => 'Simple, transparent pricing.',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Register & get access to all tools on our website.',
    'index.cta.pricing' => 'Pricing',
    'index.cta.register' => 'Sign up',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.details' => 'Details',
    'api_documentation.description' => 'Description',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.teams.breadcrumb' => 'Teams',
    'api_documentation.teams.title' => 'Teams API Documentation',
    'api_documentation.teams.header' => 'Teams',

    'api_documentation.team_members.breadcrumb' => 'Team members',
    'api_documentation.team_members.title' => 'Team members API Documentation',
    'api_documentation.team_members.header' => 'Team members',

    'api_documentation.teams_member.breadcrumb' => 'Teams member',
    'api_documentation.teams_member.title' => 'Teams member API Documentation',
    'api_documentation.teams_member.header' => 'Teams member',

    'api_documentation.user.breadcrumb' => 'User',
    'api_documentation.user.title' => 'User API Documentation',
    'api_documentation.user.header' => 'User',

    'api_documentation.payments.breadcrumb' => 'Payments',
    'api_documentation.payments.title' => 'Payments API Documentation',
    'api_documentation.payments.header' => 'Payments',

    'api_documentation.users_logs.breadcrumb' => 'Logs',
    'api_documentation.users_logs.title' => 'Logs API Documentation',
    'api_documentation.users_logs.header' => 'Logs',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',

    'contact.input.email' => 'Email address',
    'contact.input.name' => 'Full name',
    'contact.input.subject' => 'Subject',
    'contact.input.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => 'Variable commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',


    'notfound.title' => 'Not found',
    'notfound.header' => 'Page not found',
    'notfound.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'notfound.button' => 'Go back home',


    'tools.breadcrumb' => 'Tools',
    'tools.title' => 'Tools',
    'tools.tool_title' => '%s - Tools',
    'tools.menu' => 'Tools',
    'tools.header' => 'Tools',
    'tools.subheader' => 'Web tools that help you test, convert, calculate, generate different kind of things.',
    'tools.total_views' => 'Total views',
    'tools.popular_tools' => 'Popular tools',
    'tools.similar_tools' => 'Similar tools',
    'tools.share' => 'Share',
    'tools.url' => 'URL',
    'tools.result' => 'Result',
    'tools.content' => 'Content',
    'tools.text' => 'Text',
    'tools.image' => 'Image',
    'tools.quality' => 'Quality',
    'tools.precision' => 'Precision',
    'tools.bits' => 'Bits',
    'tools.nibbles' => 'Nibbles',
    'tools.bytes' => 'Bytes',
    'tools.kilobits' => 'Kilobits',
    'tools.kibibits' => 'Kibibits',
    'tools.kilobytes' => 'Kilobytes',
    'tools.kibibytes' => 'Kibibytes',
    'tools.megabits' => 'Megabits',
    'tools.mebibits' => 'Mebibits',
    'tools.megabytes' => 'Megabytes',
    'tools.mebibytes' => 'Mebibytes',
    'tools.gigabits' => 'Gigabits',
    'tools.gibibits' => 'Gibibits',
    'tools.gigabytes' => 'Gigabytes',
    'tools.gibibytes' => 'Gibibytes',
    'tools.terabits' => 'Terabits',
    'tools.tebibits' => 'Tebibits',
    'tools.terabytes' => 'Terabytes',
    'tools.tebibytes' => 'Tebibytes',
    'tools.petabits' => 'Petabits',
    'tools.pebibits' => 'Pebibits',
    'tools.petabytes' => 'Petabytes',
    'tools.pebibytes' => 'Pebibytes',
    'tools.exabits' => 'Exabits',
    'tools.exbibits' => 'Exbibits',
    'tools.exabytes' => 'Exabytes',
    'tools.exbibytes' => 'Exbibytes',
    'tools.zettabits' => 'Zettabits',
    'tools.zebibits' => 'Zebibits',
    'tools.zettabytes' => 'Zettabytes',
    'tools.zebibytes' => 'Zebiabytes',
    'tools.yottabits' => 'Yottabits',
    'tools.yobibits' => 'Yobibits',
    'tools.yottabytes' => 'Yottabytes',
    'tools.yobibytes' => 'Yobibytes',

    'tools.checker_tools' => 'Checker tools',
    'tools.checker_tools_help' => 'A collection of great checker-type tools to help you check & verify different types of things.',
    'tools.text_tools' => 'Text tools',
    'tools.text_tools_help' => 'A collection of text content related tools to help you create, modify & improve text type of content.',
    'tools.converter_tools' => 'Converter tools',
    'tools.converter_tools_help' => 'A collection of tools that help you easily convert data.',
    'tools.generator_tools' => 'Generator tools',
    'tools.generator_tools_help' => 'A collection of the most useful generator tools that you can generate data with.',
    'tools.developer_tools' => 'Developer tools',
    'tools.developer_tools_help' => 'A collection of highly useful tools mainly for developers and not only.',
    'tools.image_manipulation_tools' => 'Image manipulation tools',
    'tools.image_manipulation_tools_help' => 'A collection of tools that help modify & convert image files.',
    'tools.misc_tools' => 'Misc tools',
    'tools.misc_tools_help' => 'A collection of other random, but great & useful tools.',
    'tools.unit_converter_tools' => 'Unit converter tools',
    'tools.unit_converter_tools_help' => 'A collection of the most popular and useful tools that help you easily convert day-to-day data.',
    'tools.time_converter_tools' => 'Time converter tools',
    'tools.time_converter_tools_help' => 'A collection of date & time conversion related tools.',
    'tools.data_converter_tools' => 'Data converter tools',
    'tools.data_converter_tools_help' => 'A collection of computer data & sizing converter tools.',

    'tools.dns_lookup.name' => 'DNS Lookup',
    'tools.dns_lookup.description' => 'Find A, AAAA, CNAME, MX, NS, TXT, SOA DNS records of a host.',
    'tools.dns_lookup.meta_keywords' => '',
    'tools.dns_lookup.host' => 'Host',
    'tools.dns_lookup.error_message' => 'We could not retrieve any DNS records for your given host.',
    'tools.dns_lookup.result.type' => 'Type',
    'tools.dns_lookup.result.host' => 'Host',
    'tools.dns_lookup.result.ttl' => 'TTL',
    'tools.dns_lookup.result.ip' => 'IP',
    'tools.dns_lookup.result.target' => 'Target',
    'tools.dns_lookup.result.ipv6' => 'IPv6',
    'tools.dns_lookup.result.priority' => 'Priority',
    'tools.dns_lookup.result.entries' => 'Entries',
    'tools.dns_lookup.result.mname' => 'MNAME',
    'tools.dns_lookup.result.rname' => 'RNAME',
    'tools.dns_lookup.result.serial' => 'Serial',
    'tools.dns_lookup.result.refresh' => 'Refresh',
    'tools.dns_lookup.result.retry' => 'Retry',
    'tools.dns_lookup.result.expire' => 'Expire',
    'tools.dns_lookup.result.minimum_ttl' => 'Min. TTL',
    'tools.dns_lookup.result.flags' => 'Flags',
    'tools.dns_lookup.result.tag' => 'Tag',
    'tools.dns_lookup.result.value' => 'Value',
    'tools.dns_lookup.result.a' => 'A Records',
    'tools.dns_lookup.result.aaaa' => 'AAAA Records',
    'tools.dns_lookup.result.cname' => 'CNAME Records',
    'tools.dns_lookup.result.mx' => 'MX Records',
    'tools.dns_lookup.result.ns' => 'NS Records',
    'tools.dns_lookup.result.txt' => 'TXT Records',
    'tools.dns_lookup.result.soa' => 'SOA Records',
    'tools.dns_lookup.result.caa' => 'CAA Records',
    'tools.dns_lookup.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ip_lookup.name' => 'IP Lookup',
    'tools.ip_lookup.description' => 'Get approximate IP details.',
    'tools.ip_lookup.meta_keywords' => '',
    'tools.ip_lookup.ip' => 'IP',
    'tools.ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.ip_lookup.result.continent' => 'Continent',
    'tools.ip_lookup.result.country' => 'Country',
    'tools.ip_lookup.result.city' => 'City',
    'tools.ip_lookup.result.latitude' => 'Latitude',
    'tools.ip_lookup.result.longitude' => 'Longitude',
    'tools.ip_lookup.result.timezone' => 'Timezone',
    'tools.ip_lookup.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.reverse_ip_lookup.name' => 'Reverse IP Lookup',
    'tools.reverse_ip_lookup.description' => 'Take an IP and try to look for the domain/host associated with it.',
    'tools.reverse_ip_lookup.meta_keywords' => '',
    'tools.reverse_ip_lookup.ip' => 'IP',
    'tools.reverse_ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.reverse_ip_lookup.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ssl_lookup.name' => 'SSL Lookup',
    'tools.ssl_lookup.description' => 'Get all possible details about an SSL certificate.',
    'tools.ssl_lookup.meta_keywords' => '',
    'tools.ssl_lookup.host' => 'Host',
    'tools.ssl_lookup.error_message' => 'We could not retrieve any details for your given host.',
    'tools.ssl_lookup.result.country' => 'Country',
    'tools.ssl_lookup.result.organization' => 'Organization',
    'tools.ssl_lookup.result.common_name' => 'Common name',
    'tools.ssl_lookup.result.start_datetime' => 'Issued on',
    'tools.ssl_lookup.result.end_datetime' => 'Expiring on',
    'tools.ssl_lookup.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.whois_lookup.name' => 'Whois Lookup',
    'tools.whois_lookup.description' => 'Get all possible details about a domain name.',
    'tools.whois_lookup.meta_keywords' => '',
    'tools.whois_lookup.domain_name' => 'Domain name',
    'tools.whois_lookup.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.whois_lookup.result.nameservers' => 'Nameservers',
    'tools.whois_lookup.result.registrar' => 'Registrar',
    'tools.whois_lookup.result.start_datetime' => 'Issued on',
    'tools.whois_lookup.result.end_datetime' => 'Expiring on',
    'tools.whois_lookup.result.updated_datetime' => 'Updated on',
    'tools.whois_lookup.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ping.name' => 'Ping',
    'tools.ping.description' => 'Ping a website, server or port..',
    'tools.ping.meta_keywords' => '',
    'tools.ping.type' => 'Ping Protocol',
    'tools.ping.type_website' => 'HTTP(s)',
    'tools.ping.type_website_help' => 'Ideal for monitoring websites, APIs and web services.',
    'tools.ping.type_ping' => 'Ping (ICMP)',
    'tools.ping.type_ping_help' => 'Ideal for monitoring a server.',
    'tools.ping.type_port' => 'Host / Port',
    'tools.ping.type_port_help' => 'Ideal for monitoring databases, POP or SMTP servers.',
    'tools.ping.target_url' => 'URL',
    'tools.ping.target_host' => 'Host',
    'tools.ping.target_port' => 'Port',
    'tools.ping.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.ping.result.ping_server_id' => 'Ping Server',
    'tools.ping.result.status' => 'Status',
    'tools.ping.result.is_ok' => 'Up!',
    'tools.ping.result.is_not_ok' => 'Down!',
    'tools.ping.result.response_time' => 'Response time',
    'tools.ping.result.response_status_code' => 'Response status code',
    'tools.ping.result.error' => 'Error',
    'tools.ping.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.md5_generator.name' => 'MD5 generator',
    'tools.md5_generator.description' => 'Generate an MD5 hash of 32 characters length for any string input.',
    'tools.md5_generator.meta_keywords' => '',
    'tools.md5_generator.result' => 'MD5 Hash',
    'tools.md5_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.md2_generator.name' => 'MD2 generator',
    'tools.md2_generator.description' => 'Generate an MD2 hash for any string input.',
    'tools.md2_generator.meta_keywords' => '',
    'tools.md2_generator.result' => 'MD2 Hash',
    'tools.md2_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.md4_generator.name' => 'MD4 generator',
    'tools.md4_generator.description' => 'Generate an MD4 hash for any string input.',
    'tools.md4_generator.meta_keywords' => '',
    'tools.md4_generator.result' => 'MD4 Hash',
    'tools.md4_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.whirlpool_generator.name' => 'Whirlpool generator',
    'tools.whirlpool_generator.description' => 'Generate a whirlpool hash for any string input.',
    'tools.whirlpool_generator.meta_keywords' => '',
    'tools.whirlpool_generator.result' => 'Whirlpool Hash',
    'tools.whirlpool_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha1_generator.name' => 'SHA-1 generator',
    'tools.sha1_generator.description' => 'Generate a SHA-1 hash for any string input.',
    'tools.sha1_generator.meta_keywords' => '',
    'tools.sha1_generator.result' => 'SHA-1 Hash',
    'tools.sha1_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha224_generator.name' => 'SHA-224 generator',
    'tools.sha224_generator.description' => 'Generate a SHA-224 hash for any string input.',
    'tools.sha224_generator.meta_keywords' => '',
    'tools.sha224_generator.result' => 'SHA-224 Hash',
    'tools.sha224_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha256_generator.name' => 'SHA-256 generator',
    'tools.sha256_generator.description' => 'Generate a SHA-256 hash for any string input.',
    'tools.sha256_generator.meta_keywords' => '',
    'tools.sha256_generator.result' => 'SHA-256 Hash',
    'tools.sha256_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha384_generator.name' => 'SHA-384 generator',
    'tools.sha384_generator.description' => 'Generate a SHA-384 hash for any string input.',
    'tools.sha384_generator.meta_keywords' => '',
    'tools.sha384_generator.result' => 'SHA-384 Hash',
    'tools.sha384_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha512_generator.name' => 'SHA-512 generator',
    'tools.sha512_generator.description' => 'Generate a SHA-512 hash for any string input.',
    'tools.sha512_generator.meta_keywords' => '',
    'tools.sha512_generator.result' => 'SHA-512 Hash',
    'tools.sha512_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha512_224_generator.name' => 'SHA-512/224 generator',
    'tools.sha512_224_generator.description' => 'Generate a SHA-512/224 hash for any string input.',
    'tools.sha512_224_generator.meta_keywords' => '',
    'tools.sha512_224_generator.result' => 'SHA-512/224 Hash',
    'tools.sha512_224_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha512_256_generator.name' => 'SHA-512/256 generator',
    'tools.sha512_256_generator.description' => 'Generate a SHA-512/256 hash for any string input.',
    'tools.sha512_256_generator.meta_keywords' => '',
    'tools.sha512_256_generator.result' => 'SHA-512/256 Hash',
    'tools.sha512_256_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha3_224_generator.name' => 'SHA-3/224 generator',
    'tools.sha3_224_generator.description' => 'Generate a SHA-3/224 hash for any string input.',
    'tools.sha3_224_generator.meta_keywords' => '',
    'tools.sha3_224_generator.result' => 'SHA-3/224 Hash',
    'tools.sha3_224_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha3_256_generator.name' => 'SHA-3/256 generator',
    'tools.sha3_256_generator.description' => 'Generate a SHA-3/256 hash for any string input.',
    'tools.sha3_256_generator.meta_keywords' => '',
    'tools.sha3_256_generator.result' => 'SHA-3/256 Hash',
    'tools.sha3_256_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha3_384_generator.name' => 'SHA-3/384 generator',
    'tools.sha3_384_generator.description' => 'Generate a SHA-3/384 hash for any string input.',
    'tools.sha3_384_generator.meta_keywords' => '',
    'tools.sha3_384_generator.result' => 'SHA-3/384 Hash',
    'tools.sha3_384_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sha3_512_generator.name' => 'SHA-3/512 generator',
    'tools.sha3_512_generator.description' => 'Generate a SHA-3/512 hash for any string input.',
    'tools.sha3_512_generator.meta_keywords' => '',
    'tools.sha3_512_generator.result' => 'SHA-3/512 Hash',
    'tools.sha3_512_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.base64_encoder.name' => 'Base64 encoder',
    'tools.base64_encoder.description' => 'Encode any string input to Base64.',
    'tools.base64_encoder.meta_keywords' => '',
    'tools.base64_encoder.result' => 'Base64 encoded',
    'tools.base64_encoder.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.base64_decoder.name' => 'Base64 decoder',
    'tools.base64_decoder.description' => 'Decode Base64 input to back to string.',
    'tools.base64_decoder.meta_keywords' => '',
    'tools.base64_decoder.result' => 'Base64 decoded',
    'tools.base64_decoder.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.base64_to_image.name' => 'Base64 to Image',
    'tools.base64_to_image.description' => 'Decode Base64 input to an image.',
    'tools.base64_to_image.meta_keywords' => '',
    'tools.base64_to_image.result' => 'Image',
    'tools.base64_to_image.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.image_to_base64.name' => 'Image to Base64',
    'tools.image_to_base64.description' => 'Transform an image input to a Base64 string.',
    'tools.image_to_base64.meta_keywords' => '',
    'tools.image_to_base64.result' => 'Base64 encoded',
    'tools.image_to_base64.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.url_encoder.name' => 'URL encoder',
    'tools.url_encoder.description' => 'Encode any string input to URL format.',
    'tools.url_encoder.meta_keywords' => '',
    'tools.url_encoder.result' => 'URL encoded',
    'tools.url_encoder.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.url_decoder.name' => 'URL decoder',
    'tools.url_decoder.description' => 'Decode URL input to back to a normal string.',
    'tools.url_decoder.meta_keywords' => '',
    'tools.url_decoder.result' => 'URL decoded',
    'tools.url_decoder.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.lorem_ipsum_generator.name' => 'Lorem Ipsum generator',
    'tools.lorem_ipsum_generator.description' => 'Easily generate dummy text with the Lorem Ipsum generator.',
    'tools.lorem_ipsum_generator.meta_keywords' => '',
    'tools.lorem_ipsum_generator.amount' => 'Amount',
    'tools.lorem_ipsum_generator.type' => 'Type',
    'tools.lorem_ipsum_generator.paragraphs' => 'Paragraphs',
    'tools.lorem_ipsum_generator.sentences' => 'Sentences',
    'tools.lorem_ipsum_generator.words' => 'Words',
    'tools.lorem_ipsum_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.markdown_to_html.name' => 'Markdown to HTML',
    'tools.markdown_to_html.description' => 'Convert markdown snippets to raw HTML code.',
    'tools.markdown_to_html.meta_keywords' => '',
    'tools.markdown_to_html.markdown' => 'Markdown',
    'tools.markdown_to_html.html' => 'HTML',
    'tools.markdown_to_html.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.case_converter.name' => 'Case converter',
    'tools.case_converter.description' => 'Convert your text to any kind of text case, such as lowercase, UPPERCASE, camelCase...etc.',
    'tools.case_converter.meta_keywords' => '',
    'tools.case_converter.type' => 'Type',
    'tools.case_converter.lowercase' => 'lowercase',
    'tools.case_converter.uppercase' => 'UPPERCASE',
    'tools.case_converter.sentencecase' => 'Sentence case',
    'tools.case_converter.camelcase' => 'camelCase',
    'tools.case_converter.pascalcase' => 'PascalCase',
    'tools.case_converter.capitalcase' => 'Capital Case',
    'tools.case_converter.constantcase' => 'CONSTANT_CASE',
    'tools.case_converter.dotcase' => 'dot.case',
    'tools.case_converter.snakecase' => 'snake_case',
    'tools.case_converter.paramcase' => 'param-case',
    'tools.case_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.random_number_generator.name' => 'Random number generator',
    'tools.random_number_generator.description' => 'Generate a random number between a given range.',
    'tools.random_number_generator.meta_keywords' => '',
    'tools.random_number_generator.minimum' => 'Minimum',
    'tools.random_number_generator.maximum' => 'Maximum',
    'tools.random_number_generator.result' => 'Number',
    'tools.random_number_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.uuid_v4_generator.name' => 'UUID v4 generator',
    'tools.uuid_v4_generator.description' => 'Easily generate v4 UUID\'s (Universally unique identifier) with the help of our tool.',
    'tools.uuid_v4_generator.meta_keywords' => '',
    'tools.uuid_v4_generator.result' => 'UUID v4',
    'tools.uuid_v4_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bcrypt_generator.name' => 'Bcrypt generator',
    'tools.bcrypt_generator.description' => 'Generate a bcrypt password hash for any string input.',
    'tools.bcrypt_generator.meta_keywords' => '',
    'tools.bcrypt_generator.result' => 'Bcrypt Hash',
    'tools.bcrypt_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.password_generator.name' => 'Password generator',
    'tools.password_generator.description' => 'Generate passwords with custom length and custom settings.',
    'tools.password_generator.meta_keywords' => '',
    'tools.password_generator.characters' => 'Characters',
    'tools.password_generator.numbers' => 'Include numbers',
    'tools.password_generator.symbols' => 'Include symbols',
    'tools.password_generator.lowercase' => 'Include lowercase characters',
    'tools.password_generator.uppercase' => 'Include UPPERCASE characters',
    'tools.password_generator.result' => 'Password',
    'tools.password_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.password_strength_checker.name' => 'Password strength checker',
    'tools.password_strength_checker.description' => 'Make sure your passwords are good enough.',
    'tools.password_strength_checker.meta_keywords' => '',
    'tools.password_strength_checker.password' => 'Password',
    'tools.password_strength_checker.characters' => 'Characters',
    'tools.password_strength_checker.strength' => 'Strength',
    'tools.password_strength_checker.strength.no_data' => 'No data',
    'tools.password_strength_checker.strength.very_low' => 'Very low',
    'tools.password_strength_checker.strength.low' => 'Low',
    'tools.password_strength_checker.strength.moderate' => 'Moderate',
    'tools.password_strength_checker.strength.strong' => 'Strong',
    'tools.password_strength_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.slug_generator.name' => 'Slug generator',
    'tools.slug_generator.description' => 'Generate a URL slug for any string input.',
    'tools.slug_generator.meta_keywords' => '',
    'tools.slug_generator.result' => 'Slug',
    'tools.slug_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.html_minifier.name' => 'HTML minifier',
    'tools.html_minifier.description' => 'Minify your HTML by removing all the unnecessary characters.',
    'tools.html_minifier.meta_keywords' => '',
    'tools.html_minifier.html' => 'HTML',
    'tools.html_minifier.error_message' => 'We could not process your HTML content.',
    'tools.html_minifier.result' => 'Minified HTML',
    'tools.html_minifier.result.html_characters' => 'HTML characters',
    'tools.html_minifier.result.minified_html_characters' => 'Minified HTML characters',
    'tools.html_minifier.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.css_minifier.name' => 'CSS minifier',
    'tools.css_minifier.description' => 'Minify your CSS by removing all the unnecessary characters.',
    'tools.css_minifier.meta_keywords' => '',
    'tools.css_minifier.css' => 'CSS',
    'tools.css_minifier.error_message' => 'We could not process your CSS content.',
    'tools.css_minifier.result' => 'Minified CSS',
    'tools.css_minifier.result.css_characters' => 'CSS characters',
    'tools.css_minifier.result.minified_css_characters' => 'Minified CSS characters',
    'tools.css_minifier.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.js_minifier.name' => 'JS minifier',
    'tools.js_minifier.description' => 'Minify your JS by removing all the unnecessary characters.',
    'tools.js_minifier.meta_keywords' => '',
    'tools.js_minifier.js' => 'JS',
    'tools.js_minifier.error_message' => 'We could not process your JS content.',
    'tools.js_minifier.result' => 'Minified JS',
    'tools.js_minifier.result.js_characters' => 'JS characters',
    'tools.js_minifier.result.minified_js_characters' => 'Minified JS characters',
    'tools.js_minifier.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.user_agent_parser.name' => 'User agent parser',
    'tools.user_agent_parser.description' => 'Parse details from user agent strings.',
    'tools.user_agent_parser.meta_keywords' => '',
    'tools.user_agent_parser.user_agent' => 'User agent',
    'tools.user_agent_parser.result.browser' => 'Browser',
    'tools.user_agent_parser.result.os' => 'Operating system',
    'tools.user_agent_parser.result.device_type' => 'Device type',
    'tools.user_agent_parser.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.website_hosting_checker.name' => 'Website hosting checker',
    'tools.website_hosting_checker.description' => 'Get the web-host of a given website.',
    'tools.website_hosting_checker.meta_keywords' => '',
    'tools.website_hosting_checker.host' => 'Host',
    'tools.website_hosting_checker.error_message' => 'We could not retrieve any details for your given host.',
    'tools.website_hosting_checker.result.isp' => 'ISP',
    'tools.website_hosting_checker.result.org' => 'Organization',
    'tools.website_hosting_checker.result.country' => 'Country',
    'tools.website_hosting_checker.result.city' => 'City',
    'tools.website_hosting_checker.result.latitude' => 'Latitude',
    'tools.website_hosting_checker.result.longitude' => 'Longitude',
    'tools.website_hosting_checker.result.timezone' => 'Timezone',
    'tools.website_hosting_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.file_mime_type_checker.name' => 'File mime type checker',
    'tools.file_mime_type_checker.description' => 'Get details of any file type, such as the mime type or last edit date.',
    'tools.file_mime_type_checker.meta_keywords' => '',
    'tools.file_mime_type_checker.file' => 'File',
    'tools.file_mime_type_checker.file_type' => 'Type',
    'tools.file_mime_type_checker.file_size' => 'Size',
    'tools.file_mime_type_checker.file_name' => 'Name',
    'tools.file_mime_type_checker.file_last_modified_date' => 'Last modified date',
    'tools.file_mime_type_checker.error_message' => 'We could not retrieve any details for your given host.',
    'tools.file_mime_type_checker.result.type' => 'Type',
    'tools.file_mime_type_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gravatar_checker.name' => 'Gravatar checker',
    'tools.gravatar_checker.description' => 'Get the gravatar.com globally recognized avatar for any email.',
    'tools.gravatar_checker.meta_keywords' => '',
    'tools.gravatar_checker.email' => 'Email',
    'tools.gravatar_checker.result.mp' => 'Mistery person',
    'tools.gravatar_checker.result.monsterid' => 'Monsterid',
    'tools.gravatar_checker.result.identicon' => 'Identicon',
    'tools.gravatar_checker.result.wavatar' => 'Wavatar',
    'tools.gravatar_checker.result.retro' => 'Mistery person',
    'tools.gravatar_checker.result.robohash' => 'Robohash',
    'tools.gravatar_checker.result.blank' => 'Blank',
    'tools.gravatar_checker.open' => 'Open',
    'tools.gravatar_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.character_counter.name' => 'Character counter',
    'tools.character_counter.description' => 'Count the amount of characters and words of a given text.',
    'tools.character_counter.meta_keywords' => '',
    'tools.character_counter.result.characters' => 'Characters',
    'tools.character_counter.result.words' => 'Words',
    'tools.character_counter.result.lines' => 'Lines',
    'tools.character_counter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.list_randomizer.name' => 'List randomizer',
    'tools.list_randomizer.description' => 'Easily convert a list of given text into a randomized list.',
    'tools.list_randomizer.meta_keywords' => '',
    'tools.list_randomizer.result' => 'Randomized',
    'tools.list_randomizer.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.reverse_words.name' => 'Reverse words',
    'tools.reverse_words.description' => 'Reverse the words in a given sentence or paragraph with ease.',
    'tools.reverse_words.meta_keywords' => '',
    'tools.reverse_words.result' => 'Reversed',
    'tools.reverse_words.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.reverse_letters.name' => 'Reverse letters',
    'tools.reverse_letters.description' => 'Reverse the letters in a given sentence or paragraph with ease.',
    'tools.reverse_letters.meta_keywords' => '',
    'tools.reverse_letters.result' => 'Reversed',
    'tools.reverse_letters.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.emojis_remover.name' => 'Emojis remover',
    'tools.emojis_remover.description' => 'Remove all the emojis from any given text with ease.',
    'tools.emojis_remover.meta_keywords' => '',
    'tools.emojis_remover.result' => 'Text without emojis',
    'tools.emojis_remover.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.reverse_list.name' => 'Reverse list',
    'tools.reverse_list.description' => 'Reverse a list of given text lines.',
    'tools.reverse_list.meta_keywords' => '',
    'tools.reverse_list.result' => 'Reversed',
    'tools.reverse_list.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.list_alphabetizer.name' => 'List alphabetizer',
    'tools.list_alphabetizer.description' => 'Order text lines in alphabetical order (A-Z or Z-A) with ease.',
    'tools.list_alphabetizer.meta_keywords' => '',
    'tools.list_alphabetizer.type' => 'Type',
    'tools.list_alphabetizer.result' => 'Alphabetized',
    'tools.list_alphabetizer.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.upside_down_text_generator.name' => 'Upside down text generator',
    'tools.upside_down_text_generator.description' => 'Flip, upside down text with ease.',
    'tools.upside_down_text_generator.meta_keywords' => '',
    'tools.upside_down_text_generator.reverse' => 'Reverse text',
    'tools.upside_down_text_generator.result' => 'Flipped',
    'tools.upside_down_text_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.old_english_text_generator.name' => 'Old English text generator',
    'tools.old_english_text_generator.description' => 'Convert normal text to old english font type.',
    'tools.old_english_text_generator.meta_keywords' => '',
    'tools.old_english_text_generator.result' => 'Old English',
    'tools.old_english_text_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.cursive_text_generator.name' => 'Cursive text generator',
    'tools.cursive_text_generator.description' => 'Convert normal text to cursive font type.',
    'tools.cursive_text_generator.meta_keywords' => '',
    'tools.cursive_text_generator.result' => 'Cursive text',
    'tools.cursive_text_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.url_parser.name' => 'URL parser',
    'tools.url_parser.description' => 'Parse details from any URLs.',
    'tools.url_parser.meta_keywords' => '',
    'tools.url_parser.result.scheme' => 'Scheme',
    'tools.url_parser.result.host' => 'Host',
    'tools.url_parser.result.path' => 'Path',
    'tools.url_parser.result.query' => 'Query',
    'tools.url_parser.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.color_converter.name' => 'Color converter',
    'tools.color_converter.description' => 'Convert your color to multiple other formats.',
    'tools.color_converter.meta_keywords' => '',
    'tools.color_converter.color' => 'Color',
    'tools.color_converter.color_help' => 'Accepted formats: HEX, HEX alpha, RGB, RGBA, HSV, HSL, HSLA.',
    'tools.color_converter.hex' => 'HEX',
    'tools.color_converter.hexa' => 'HEX Alpha',
    'tools.color_converter.rgb' => 'RGB',
    'tools.color_converter.rgba' => 'RGBA',
    'tools.color_converter.hsv' => 'HSV',
    'tools.color_converter.hsl' => 'HSL',
    'tools.color_converter.hsla' => 'HSLA',
    'tools.color_converter.error_message' => 'No valid color format was detected.',
    'tools.color_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.http_headers_lookup.name' => 'HTTP headers lookup',
    'tools.http_headers_lookup.description' => 'Get all the HTTP headers that an URL returns for a typical GET request.',
    'tools.http_headers_lookup.meta_keywords' => '',
    'tools.http_headers_lookup.error_message' => 'We could not get any information for your entered URL.',
    'tools.http_headers_lookup.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.duplicate_lines_remover.name' => 'Duplicate lines remover',
    'tools.duplicate_lines_remover.description' => 'Easily remove duplicate lines from a text.',
    'tools.duplicate_lines_remover.meta_keywords' => '',
    'tools.duplicate_lines_remover.result.lines' => 'Lines',
    'tools.duplicate_lines_remover.result.new_lines' => 'New lines',
    'tools.duplicate_lines_remover.result.removed_lines' => 'Removed lines',
    'tools.duplicate_lines_remover.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.text_to_speech.name' => 'Text to speech',
    'tools.text_to_speech.description' => 'Use the Google translator API to generate text to speech audio.',
    'tools.text_to_speech.meta_keywords' => '',
    'tools.text_to_speech.language_code' => 'Language code',
    'tools.text_to_speech.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.idn_punnycode_converter.name' => 'IDN Punnycode converter',
    'tools.idn_punnycode_converter.description' => 'Easily convert IDN to Punnycode and back.',
    'tools.idn_punnycode_converter.meta_keywords' => '',
    'tools.idn_punnycode_converter.type' => 'Type',
    'tools.idn_punnycode_converter.to_punnycode' => 'Convert to Punnycode/ASCII',
    'tools.idn_punnycode_converter.to_idn' => 'Convert to IDN/Text',
    'tools.idn_punnycode_converter.result.punnycode' => 'Punnycode/ASCII',
    'tools.idn_punnycode_converter.result.idn' => 'IDN/Text',
    'tools.idn_punnycode_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.json_validator_beautifier.name' => 'JSON validator & beautifier',
    'tools.json_validator_beautifier.description' => 'Validate JSON content and make it looks good.',
    'tools.json_validator_beautifier.meta_keywords' => '',
    'tools.json_validator_beautifier.json' => 'JSON',
    'tools.json_validator_beautifier.error_message' => 'JSON content is invalid.',
    'tools.json_validator_beautifier.success_message' => 'JSON content is valid.',
    'tools.json_validator_beautifier.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.qr_code_reader.name' => 'QR code reader',
    'tools.qr_code_reader.description' => 'Upload a QR code image and extract the data out of it.',
    'tools.qr_code_reader.meta_keywords' => '',
    'tools.qr_code_reader.image' => 'QR code image',
    'tools.qr_code_reader.result' => 'Data',
    'tools.qr_code_reader.result.no_data' => 'No data found.',
    'tools.qr_code_reader.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.meta_tags_checker.name' => 'Meta tags checker',
    'tools.meta_tags_checker.description' => 'Get & verify the meta tags of any website.',
    'tools.meta_tags_checker.meta_keywords' => '',
    'tools.meta_tags_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.meta_tags_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.exif_reader.name' => 'Exif reader',
    'tools.exif_reader.description' => 'Upload a image and extract the data out of it.',
    'tools.exif_reader.meta_keywords' => '',
    'tools.exif_reader.result' => 'Data',
    'tools.exif_reader.result.no_data' => 'No data found.',
    'tools.exif_reader.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.color_picker.name' => 'Color picker',
    'tools.color_picker.description' => 'The easiest way to select a color from the color wheel and get the results in any format.',
    'tools.color_picker.meta_keywords' => '',
    'tools.color_picker.color' => 'Color',
    'tools.color_picker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hex_to_hexa.name' => 'HEX to HEXA',
    'tools.hex_to_hexa.description' => 'Convert your HEX color format to HEXA format.',
    'tools.hex_to_hexa.meta_keywords' => '',
    'tools.hex_to_hexa.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hex_to_rgb.name' => 'HEX to RGB',
    'tools.hex_to_rgb.description' => 'Convert your HEX color format to RGB format.',
    'tools.hex_to_rgb.meta_keywords' => '',
    'tools.hex_to_rgb.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hex_to_rgba.name' => 'HEX to RGBA',
    'tools.hex_to_rgba.description' => 'Convert your HEX color format to RGBA format.',
    'tools.hex_to_rgba.meta_keywords' => '',
    'tools.hex_to_rgba.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hex_to_hsv.name' => 'HEX to HSV',
    'tools.hex_to_hsv.description' => 'Convert your HEX color format to HSV format.',
    'tools.hex_to_hsv.meta_keywords' => '',
    'tools.hex_to_hsv.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hex_to_hsl.name' => 'HEX to HSL',
    'tools.hex_to_hsl.description' => 'Convert your HEX color format to HSL format.',
    'tools.hex_to_hsl.meta_keywords' => '',
    'tools.hex_to_hsl.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hex_to_hsla.name' => 'HEX to HSLA',
    'tools.hex_to_hsla.description' => 'Convert your HEX color format to HSLA format.',
    'tools.hex_to_hsla.meta_keywords' => '',
    'tools.hex_to_hsla.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hexa_to_hex.name' => 'HEXA to HEX',
    'tools.hexa_to_hex.description' => 'Convert your HEXA color format to HEX format.',
    'tools.hexa_to_hex.meta_keywords' => '',
    'tools.hexa_to_hex.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hexa_to_rgb.name' => 'HEXA to RGB',
    'tools.hexa_to_rgb.description' => 'Convert your HEXA color format to RGB format.',
    'tools.hexa_to_rgb.meta_keywords' => '',
    'tools.hexa_to_rgb.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hexa_to_rgba.name' => 'HEXA to RGBA',
    'tools.hexa_to_rgba.description' => 'Convert your HEXA color format to RGBA format.',
    'tools.hexa_to_rgba.meta_keywords' => '',
    'tools.hexa_to_rgba.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hexa_to_hsv.name' => 'HEXA to HSV',
    'tools.hexa_to_hsv.description' => 'Convert your HEXA color format to HSV format.',
    'tools.hexa_to_hsv.meta_keywords' => '',
    'tools.hexa_to_hsv.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hexa_to_hsl.name' => 'HEXA to HSL',
    'tools.hexa_to_hsl.description' => 'Convert your HEXA color format to HSL format.',
    'tools.hexa_to_hsl.meta_keywords' => '',
    'tools.hexa_to_hsl.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hexa_to_hsla.name' => 'HEXA to HSLA',
    'tools.hexa_to_hsla.description' => 'Convert your HEXA color format to HSLA format.',
    'tools.hexa_to_hsla.meta_keywords' => '',
    'tools.hexa_to_hsla.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgb_to_hex.name' => 'RGB to HEX',
    'tools.rgb_to_hex.description' => 'Convert your RGB color format to HEX format.',
    'tools.rgb_to_hex.meta_keywords' => '',
    'tools.rgb_to_hex.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgb_to_hexa.name' => 'RGB to HEXA',
    'tools.rgb_to_hexa.description' => 'Convert your RGB color format to HEXA format.',
    'tools.rgb_to_hexa.meta_keywords' => '',
    'tools.rgb_to_hexa.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgb_to_rgba.name' => 'RGB to RGBA',
    'tools.rgb_to_rgba.description' => 'Convert your RGB color format to RGBA format.',
    'tools.rgb_to_rgba.meta_keywords' => '',
    'tools.rgb_to_rgba.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgb_to_hsv.name' => 'RGB to HSV',
    'tools.rgb_to_hsv.description' => 'Convert your RGB color format to HSV format.',
    'tools.rgb_to_hsv.meta_keywords' => '',
    'tools.rgb_to_hsv.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgb_to_hsl.name' => 'RGB to HSL',
    'tools.rgb_to_hsl.description' => 'Convert your RGB color format to HSL format.',
    'tools.rgb_to_hsl.meta_keywords' => '',
    'tools.rgb_to_hsl.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgb_to_hsla.name' => 'RGB to HSLA',
    'tools.rgb_to_hsla.description' => 'Convert your RGB color format to HSLA format.',
    'tools.rgb_to_hsla.meta_keywords' => '',
    'tools.rgb_to_hsla.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgba_to_hex.name' => 'RGBA to HEX',
    'tools.rgba_to_hex.description' => 'Convert your RGBA color format to HEX format.',
    'tools.rgba_to_hex.meta_keywords' => '',
    'tools.rgba_to_hex.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgba_to_hexa.name' => 'RGBA to HEXA',
    'tools.rgba_to_hexa.description' => 'Convert your RGBA color format to HEXA format.',
    'tools.rgba_to_hexa.meta_keywords' => '',
    'tools.rgba_to_hexa.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgba_to_rgb.name' => 'RGBA to RGB',
    'tools.rgba_to_rgb.description' => 'Convert your RGBA color format to RGB format.',
    'tools.rgba_to_rgb.meta_keywords' => '',
    'tools.rgba_to_rgb.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgba_to_hsv.name' => 'RGBA to HSV',
    'tools.rgba_to_hsv.description' => 'Convert your RGBA color format to HSV format.',
    'tools.rgba_to_hsv.meta_keywords' => '',
    'tools.rgba_to_hsv.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgba_to_hsl.name' => 'RGBA to HSL',
    'tools.rgba_to_hsl.description' => 'Convert your RGBA color format to HSL format.',
    'tools.rgba_to_hsl.meta_keywords' => '',
    'tools.rgba_to_hsl.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.rgba_to_hsla.name' => 'RGBA to HSLA',
    'tools.rgba_to_hsla.description' => 'Convert your RGBA color format to HSLA format.',
    'tools.rgba_to_hsla.meta_keywords' => '',
    'tools.rgba_to_hsla.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsv_to_hex.name' => 'HSV to HEX',
    'tools.hsv_to_hex.description' => 'Convert your HSV color format to HEX format.',
    'tools.hsv_to_hex.meta_keywords' => '',
    'tools.hsv_to_hex.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsv_to_hexa.name' => 'HSV to HEXA',
    'tools.hsv_to_hexa.description' => 'Convert your HSV color format to HEXA format.',
    'tools.hsv_to_hexa.meta_keywords' => '',
    'tools.hsv_to_hexa.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsv_to_rgba.name' => 'HSV to RGBA',
    'tools.hsv_to_rgba.description' => 'Convert your RGBA color format to RGBA format.',
    'tools.hsv_to_rgba.meta_keywords' => '',
    'tools.hsv_to_rgba.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsv_to_rgb.name' => 'HSV to RGB',
    'tools.hsv_to_rgb.description' => 'Convert your HSV color format to RGB format.',
    'tools.hsv_to_rgb.meta_keywords' => '',
    'tools.hsv_to_rgb.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsv_to_hsl.name' => 'HSV to HSL',
    'tools.hsv_to_hsl.description' => 'Convert your HSV color format to HSL format.',
    'tools.hsv_to_hsl.meta_keywords' => '',
    'tools.hsv_to_hsl.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsv_to_hsla.name' => 'HSV to HSLA',
    'tools.hsv_to_hsla.description' => 'Convert your HSV color format to HSLA format.',
    'tools.hsv_to_hsla.meta_keywords' => '',
    'tools.hsv_to_hsla.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsl_to_hex.name' => 'HSL to HEX',
    'tools.hsl_to_hex.description' => 'Convert your HSL color format to HEX format.',
    'tools.hsl_to_hex.meta_keywords' => '',
    'tools.hsl_to_hex.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsl_to_hexa.name' => 'HSL to HEXA',
    'tools.hsl_to_hexa.description' => 'Convert your HSL color format to HEXA format.',
    'tools.hsl_to_hexa.meta_keywords' => '',
    'tools.hsl_to_hexa.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsl_to_rgba.name' => 'HSL to RGBA',
    'tools.hsl_to_rgba.description' => 'Convert your RGBA color format to RGBA format.',
    'tools.hsl_to_rgba.meta_keywords' => '',
    'tools.hsl_to_rgba.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsl_to_rgb.name' => 'HSL to RGB',
    'tools.hsl_to_rgb.description' => 'Convert your HSL color format to RGB format.',
    'tools.hsl_to_rgb.meta_keywords' => '',
    'tools.hsl_to_rgb.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsl_to_hsv.name' => 'HSL to HSV',
    'tools.hsl_to_hsv.description' => 'Convert your HSL color format to HSV format.',
    'tools.hsl_to_hsv.meta_keywords' => '',
    'tools.hsl_to_hsv.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsl_to_hsla.name' => 'HSL to HSLA',
    'tools.hsl_to_hsla.description' => 'Convert your HSL color format to HSLA format.',
    'tools.hsl_to_hsla.meta_keywords' => '',
    'tools.hsl_to_hsla.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsla_to_hex.name' => 'HSLA to HEX',
    'tools.hsla_to_hex.description' => 'Convert your HSLA color format to HEX format.',
    'tools.hsla_to_hex.meta_keywords' => '',
    'tools.hsla_to_hex.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsla_to_hexa.name' => 'HSLA to HEXA',
    'tools.hsla_to_hexa.description' => 'Convert your HSLA color format to HEXA format.',
    'tools.hsla_to_hexa.meta_keywords' => '',
    'tools.hsla_to_hexa.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsla_to_rgba.name' => 'HSLA to RGBA',
    'tools.hsla_to_rgba.description' => 'Convert your RGBA color format to RGBA format.',
    'tools.hsla_to_rgba.meta_keywords' => '',
    'tools.hsla_to_rgba.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsla_to_rgb.name' => 'HSLA to RGB',
    'tools.hsla_to_rgb.description' => 'Convert your HSLA color format to RGB format.',
    'tools.hsla_to_rgb.meta_keywords' => '',
    'tools.hsla_to_rgb.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsla_to_hsv.name' => 'HSLA to HSV',
    'tools.hsla_to_hsv.description' => 'Convert your HSLA color format to HSV format.',
    'tools.hsla_to_hsv.meta_keywords' => '',
    'tools.hsla_to_hsv.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hsla_to_hsl.name' => 'HSLA to HSL',
    'tools.hsla_to_hsl.description' => 'Convert your HSLA color format to HSL format.',
    'tools.hsla_to_hsl.meta_keywords' => '',
    'tools.hsla_to_hsl.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.sql_beautifier.name' => 'SQL formatter/beautifier',
    'tools.sql_beautifier.description' => 'Format & beautify your SQL code with ease.',
    'tools.sql_beautifier.meta_keywords' => '',
    'tools.sql_beautifier.sql' => 'SQL',
    'tools.sql_beautifier.result' => 'Beautified SQL',
    'tools.sql_beautifier.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.html_entity_converter.name' => 'HTML entity converter',
    'tools.html_entity_converter.description' => 'Encode or decode HTML entities for any given input.',
    'tools.html_entity_converter.meta_keywords' => '',
    'tools.html_entity_converter.type' => 'Type',
    'tools.html_entity_converter.encode' => 'Encode',
    'tools.html_entity_converter.decode' => 'Decode',
    'tools.html_entity_converter.result.encoded' => 'HTML entity encoded',
    'tools.html_entity_converter.result.decoded' => 'HTML entity decoded',
    'tools.html_entity_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.binary_converter.name' => 'Binary converter',
    'tools.binary_converter.description' => 'Convert text to binary and the other way for any string input.',
    'tools.binary_converter.meta_keywords' => '',
    'tools.binary_converter.type' => 'Type',
    'tools.binary_converter.to_binary' => 'To binary',
    'tools.binary_converter.to_text' => 'To text',
    'tools.binary_converter.result.binary' => 'Binary',
    'tools.binary_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hex_converter.name' => 'Hex converter',
    'tools.hex_converter.description' => 'Convert text to hexadecimal and the other way for any string input.',
    'tools.hex_converter.meta_keywords' => '',
    'tools.hex_converter.type' => 'Type',
    'tools.hex_converter.to_hex' => 'To hex',
    'tools.hex_converter.to_text' => 'To text',
    'tools.hex_converter.result.hex' => 'Hex',
    'tools.hex_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ascii_converter.name' => 'Ascii converter',
    'tools.ascii_converter.description' => 'Convert text to ascii and the other way for any string input.',
    'tools.ascii_converter.meta_keywords' => '',
    'tools.ascii_converter.type' => 'Type',
    'tools.ascii_converter.to_ascii' => 'To ascii',
    'tools.ascii_converter.to_text' => 'To text',
    'tools.ascii_converter.result.ascii' => 'Ascii',
    'tools.ascii_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.decimal_converter.name' => 'Decimal converter',
    'tools.decimal_converter.description' => 'Convert text to decimal and the other way for any string input.',
    'tools.decimal_converter.meta_keywords' => '',
    'tools.decimal_converter.type' => 'Type',
    'tools.decimal_converter.to_decimal' => 'To decimal',
    'tools.decimal_converter.to_text' => 'To text',
    'tools.decimal_converter.result.decimal' => 'Decimal',
    'tools.decimal_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.octal_converter.name' => 'Octal converter',
    'tools.octal_converter.description' => 'Convert text to octal and the other way for any string input.',
    'tools.octal_converter.meta_keywords' => '',
    'tools.octal_converter.type' => 'Type',
    'tools.octal_converter.to_octal' => 'To octal',
    'tools.octal_converter.to_text' => 'To text',
    'tools.octal_converter.result.octal' => 'Octal',
    'tools.octal_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.morse_converter.name' => 'Morse converter',
    'tools.morse_converter.description' => 'Convert text to morse and the other way for any string input.',
    'tools.morse_converter.meta_keywords' => '',
    'tools.morse_converter.type' => 'Type',
    'tools.morse_converter.to_morse' => 'To morse',
    'tools.morse_converter.to_text' => 'To text',
    'tools.morse_converter.result.morse' => 'Morse',
    'tools.morse_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.number_to_words_converter.name' => 'Number to words converter',
    'tools.number_to_words_converter.description' => 'Convert a number to written, spelled out words.',
    'tools.number_to_words_converter.meta_keywords' => '',
    'tools.number_to_words_converter.number' => 'Number',
    'tools.number_to_words_converter.language' => 'Language',
    'tools.number_to_words_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.json_to_php_array_converter.name' => 'JSON to PHP Array converter',
    'tools.json_to_php_array_converter.description' => 'Convert a valid JSON string to PHP array syntax.',
    'tools.json_to_php_array_converter.meta_keywords' => '',
    'tools.json_to_php_array_converter.json' => 'JSON',
    'tools.json_to_php_array_converter.result' => 'PHP Array',
    'tools.json_to_php_array_converter.error_message' => 'JSON content is invalid.',
    'tools.json_to_php_array_converter.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.mailto_link_generator.name' => 'Mailto link generator',
    'tools.mailto_link_generator.description' => 'Generate deep link mailto with subject, body, cc, bcc & get the HTML code as well.',
    'tools.mailto_link_generator.meta_keywords' => '',
    'tools.mailto_link_generator.to' => 'To email',
    'tools.mailto_link_generator.cc' => 'CC',
    'tools.mailto_link_generator.bcc' => 'BCC',
    'tools.mailto_link_generator.subject' => 'Subject',
    'tools.mailto_link_generator.body' => 'Body content',
    'tools.mailto_link_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.youtube_thumbnail_downloader.name' => 'YouTube thumbnail downloader',
    'tools.youtube_thumbnail_downloader.description' => 'Easily download any YouTube video thumbnail in all the available sizes.',
    'tools.youtube_thumbnail_downloader.url' => 'YouTube video URL',
    'tools.youtube_thumbnail_downloader.invalid_url' => 'Invalid YouTube video URL.',
    'tools.youtube_thumbnail_downloader.result.default' => 'Default (120x90)',
    'tools.youtube_thumbnail_downloader.result.hqdefault' => 'High (480x360)',
    'tools.youtube_thumbnail_downloader.result.mqdefault' => 'Medium (320x180)',
    'tools.youtube_thumbnail_downloader.result.sddefault' => 'SD (640x480)',
    'tools.youtube_thumbnail_downloader.result.maxresdefault' => 'HD (1280x720)',
    'tools.youtube_thumbnail_downloader.open' => 'Open',
    'tools.youtube_thumbnail_downloader.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.safe_url_checker.name' => 'Safe URL checker',
    'tools.safe_url_checker.description' => 'Check if the URL is banned and marked as safe/unsafe by Google.',
    'tools.safe_url_checker.result.safe' => 'Your URL is marked as safe.',
    'tools.safe_url_checker.result.unsafe' => 'Your URL is marked as unsafe.',
    'tools.safe_url_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.utm_link_generator.name' => 'UTM link generator',
    'tools.utm_link_generator.description' => 'Easily add UTM valid parameters and generate a UTM trackable link.',
    'tools.utm_link_generator.meta_keywords' => '',
    'tools.utm_link_generator.utm_source' => 'UTM Source',
    'tools.utm_link_generator.utm_medium' => 'UTM Medium',
    'tools.utm_link_generator.utm_campaign' => 'UTM Campaign',
    'tools.utm_link_generator.utm_content' => 'UTM Content',
    'tools.utm_link_generator.utm_term' => 'UTM Term',
    'tools.utm_link_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.whatsapp_link_generator.name' => 'WhatsApp link generator',
    'tools.whatsapp_link_generator.description' => 'Generate whatsapp message links with ease.',
    'tools.whatsapp_link_generator.meta_keywords' => '',
    'tools.whatsapp_link_generator.phone' => 'Phone number',
    'tools.whatsapp_link_generator.prefilled_message' => 'Prefilled message',
    'tools.whatsapp_link_generator.prefilled_message_help' => 'Messages on WhatsApp can be also formatted, <a href="https://faq.whatsapp.com/general/chats/how-to-format-your-messages/?lang=en">learn more</a>.',
    'tools.whatsapp_link_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.youtube_timestamp_link_generator.name' => 'YouTube Timestamp link generator',
    'tools.youtube_timestamp_link_generator.description' => 'Generated youtube links with exact start timestamp, helpful for mobile users.',
    'tools.youtube_timestamp_link_generator.meta_keywords' => '',
    'tools.youtube_timestamp_link_generator.url' => 'YouTube video URL',
    'tools.youtube_timestamp_link_generator.start_minute' => 'Min',
    'tools.youtube_timestamp_link_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.google_cache_checker.name' => 'Google cache checker',
    'tools.google_cache_checker.description' => 'Check if the URL is cached or not by Google.',
    'tools.google_cache_checker.meta_keywords' => '',
    'tools.google_cache_checker.result.cached' => 'This URL is cached (%s).',
    'tools.google_cache_checker.result.not_cached' => 'This URL is not cached.',
    'tools.google_cache_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.google_cache_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.url_redirect_checker.name' => 'URL redirect checker',
    'tools.url_redirect_checker.description' => 'Check for 301 & 302 redirects of a specific URL. It will check for up to 10 redirects.',
    'tools.url_redirect_checker.meta_keywords' => '',
    'tools.url_redirect_checker.status_code' => 'Status code',
    'tools.url_redirect_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.url_redirect_checker.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.image_optimizer.name' => 'Image optimizer',
    'tools.image_optimizer.description' => 'Compress and optimize images for a smaller image size but still high quality.',
    'tools.image_optimizer.meta_keywords' => '',
    'tools.image_optimizer.result.original_size' => 'Original size',
    'tools.image_optimizer.result.new_size' => 'New size',
    'tools.image_optimizer.open' => 'Open',
    'tools.image_optimizer.error_message' => 'We could not process your given image at this moment in time.',
    'tools.image_optimizer.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.png_to_jpg.name' => 'PNG to JPG',
    'tools.png_to_jpg.description' => 'Easily convert PNG image files to JPG.',
    'tools.png_to_jpg.meta_keywords' => '',
    'tools.png_to_jpg.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.png_to_webp.name' => 'PNG to WEBP',
    'tools.png_to_webp.description' => 'Easily convert PNG image files to WEBP.',
    'tools.png_to_webp.meta_keywords' => '',
    'tools.png_to_webp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.png_to_bmp.name' => 'PNG to BMP',
    'tools.png_to_bmp.description' => 'Easily convert PNG image files to BMP.',
    'tools.png_to_bmp.meta_keywords' => '',
    'tools.png_to_bmp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.png_to_gif.name' => 'PNG to GIF',
    'tools.png_to_gif.description' => 'Easily convert PNG image files to GIF.',
    'tools.png_to_gif.meta_keywords' => '',
    'tools.png_to_gif.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.png_to_ico.name' => 'PNG to ICO',
    'tools.png_to_ico.description' => 'Easily convert PNG image files to ICO.',
    'tools.png_to_ico.meta_keywords' => '',
    'tools.png_to_ico.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.jpg_to_png.name' => 'JPG to PNG',
    'tools.jpg_to_png.description' => 'Easily convert JPG image files to PNG.',
    'tools.jpg_to_png.meta_keywords' => '',
    'tools.jpg_to_png.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.jpg_to_webp.name' => 'JPG to WEBP',
    'tools.jpg_to_webp.description' => 'Easily convert JPG image files to WEBP.',
    'tools.jpg_to_webp.meta_keywords' => '',
    'tools.jpg_to_webp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.jpg_to_bmp.name' => 'JPG to BMP',
    'tools.jpg_to_bmp.description' => 'Easily convert JPG image files to BMP.',
    'tools.jpg_to_bmp.meta_keywords' => '',
    'tools.jpg_to_bmp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.jpg_to_gif.name' => 'JPG to GIF',
    'tools.jpg_to_gif.description' => 'Easily convert JPG image files to GIF.',
    'tools.jpg_to_gif.meta_keywords' => '',
    'tools.jpg_to_gif.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.jpg_to_ico.name' => 'JPG to ICO',
    'tools.jpg_to_ico.description' => 'Easily convert JPG image files to ICO.',
    'tools.jpg_to_ico.meta_keywords' => '',
    'tools.jpg_to_ico.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.webp_to_png.name' => 'WEBP to PNG',
    'tools.webp_to_png.description' => 'Easily convert WEBP image files to PNG.',
    'tools.webp_to_png.meta_keywords' => '',
    'tools.webp_to_png.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.webp_to_jpg.name' => 'WEBP to JPG',
    'tools.webp_to_jpg.description' => 'Easily convert WEBP image files to JPG.',
    'tools.webp_to_jpg.meta_keywords' => '',
    'tools.webp_to_jpg.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.webp_to_ico.name' => 'WEBP to ICO',
    'tools.webp_to_ico.description' => 'Easily convert WEBP image files to ICO.',
    'tools.webp_to_ico.meta_keywords' => '',
    'tools.webp_to_ico.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.webp_to_bmp.name' => 'WEBP to BMP',
    'tools.webp_to_bmp.description' => 'Easily convert WEBP image files to BMP.',
    'tools.webp_to_bmp.meta_keywords' => '',
    'tools.webp_to_bmp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.webp_to_gif.name' => 'WEBP to GIF',
    'tools.webp_to_gif.description' => 'Easily convert WEBP image files to GIF.',
    'tools.webp_to_gif.meta_keywords' => '',
    'tools.webp_to_gif.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bmp_to_png.name' => 'BMP to PNG',
    'tools.bmp_to_png.description' => 'Easily convert BMP image files to PNG.',
    'tools.bmp_to_png.meta_keywords' => '',
    'tools.bmp_to_png.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bmp_to_jpg.name' => 'BMP to JPG',
    'tools.bmp_to_jpg.description' => 'Easily convert BMP image files to JPG.',
    'tools.bmp_to_jpg.meta_keywords' => '',
    'tools.bmp_to_jpg.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bmp_to_ico.name' => 'BMP to ICO',
    'tools.bmp_to_ico.description' => 'Easily convert BMP image files to ICO.',
    'tools.bmp_to_ico.meta_keywords' => '',
    'tools.bmp_to_ico.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bmp_to_webp.name' => 'BMP to WEBP',
    'tools.bmp_to_webp.description' => 'Easily convert BMP image files to WEBP.',
    'tools.bmp_to_webp.meta_keywords' => '',
    'tools.bmp_to_webp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bmp_to_gif.name' => 'BMP to GIF',
    'tools.bmp_to_gif.description' => 'Easily convert BMP image files to GIF.',
    'tools.bmp_to_gif.meta_keywords' => '',
    'tools.bmp_to_gif.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ico_to_png.name' => 'ICO to PNG',
    'tools.ico_to_png.description' => 'Easily convert ICO image files to PNG.',
    'tools.ico_to_png.meta_keywords' => '',
    'tools.ico_to_png.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ico_to_jpg.name' => 'ICO to JPG',
    'tools.ico_to_jpg.description' => 'Easily convert ICO image files to JPG.',
    'tools.ico_to_jpg.meta_keywords' => '',
    'tools.ico_to_jpg.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ico_to_bmp.name' => 'ICO to BMP',
    'tools.ico_to_bmp.description' => 'Easily convert ICO image files to BMP.',
    'tools.ico_to_bmp.meta_keywords' => '',
    'tools.ico_to_bmp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ico_to_webp.name' => 'ICO to WEBP',
    'tools.ico_to_webp.description' => 'Easily convert ICO image files to WEBP.',
    'tools.ico_to_webp.meta_keywords' => '',
    'tools.ico_to_webp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.ico_to_gif.name' => 'ICO to GIF',
    'tools.ico_to_gif.description' => 'Easily convert ICO image files to GIF.',
    'tools.ico_to_gif.meta_keywords' => '',
    'tools.ico_to_gif.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gif_to_png.name' => 'GIF to PNG',
    'tools.gif_to_png.description' => 'Easily convert GIF image files to PNG.',
    'tools.gif_to_png.meta_keywords' => '',
    'tools.gif_to_png.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gif_to_jpg.name' => 'GIF to JPG',
    'tools.gif_to_jpg.description' => 'Easily convert GIF image files to JPG.',
    'tools.gif_to_jpg.meta_keywords' => '',
    'tools.gif_to_jpg.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gif_to_bmp.name' => 'GIF to BMP',
    'tools.gif_to_bmp.description' => 'Easily convert GIF image files to ICO.',
    'tools.gif_to_bmp.meta_keywords' => '',
    'tools.gif_to_bmp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gif_to_webp.name' => 'GIF to WEBP',
    'tools.gif_to_webp.description' => 'Easily convert GIF image files to WEBP.',
    'tools.gif_to_webp.meta_keywords' => '',
    'tools.gif_to_webp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gif_to_ico.name' => 'GIF to ICO',
    'tools.gif_to_ico.description' => 'Easily convert GIF image files to ICO.',
    'tools.gif_to_ico.meta_keywords' => '',
    'tools.gif_to_ico.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.heic_to_png.name' => 'HEIC to PNG',
    'tools.heic_to_png.description' => 'Easily convert HEIC image files to PNG.',
    'tools.heic_to_png.meta_keywords' => '',
    'tools.heic_to_png.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.heic_to_gif.name' => 'HEIC to GIF',
    'tools.heic_to_gif.description' => 'Easily convert HEIC image files to GIF.',
    'tools.heic_to_gif.meta_keywords' => '',
    'tools.heic_to_gif.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.heic_to_jpg.name' => 'HEIC to JPG',
    'tools.heic_to_jpg.description' => 'Easily convert HEIC image files to JPG.',
    'tools.heic_to_jpg.meta_keywords' => '',
    'tools.heic_to_jpg.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.text_separator.name' => 'Text separator',
    'tools.text_separator.description' => 'Separate text back and forth by new lines, commas, dots...etc.',
    'tools.text_separator.meta_keywords' => '',
    'tools.text_separator.separated_by' => 'Currently separated by',
    'tools.text_separator.separate_by' => 'Separate by',
    'tools.text_separator.new_line' => 'New line',
    'tools.text_separator.space' => 'Space',
    'tools.text_separator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.email_extractor.name' => 'Email extractor',
    'tools.email_extractor.description' => 'Extract email addresses from any kind of text content.',
    'tools.email_extractor.meta_keywords' => '',
    'tools.email_extractor.result.count' => 'Count',
    'tools.email_extractor.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.url_extractor.name' => 'URL extractor',
    'tools.url_extractor.description' => 'Extract http/https URLs from any kind of text content.',
    'tools.url_extractor.meta_keywords' => '',
    'tools.url_extractor.result.count' => 'Count',
    'tools.url_extractor.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.text_size_calculator.name' => 'Text size calculator',
    'tools.text_size_calculator.description' => 'Get the size of a text in bytes (B), Kilobytes (KB) or Megabytes (MB).',
    'tools.text_size_calculator.meta_keywords' => '',
    'tools.text_size_calculator.result' => 'Size',
    'tools.text_size_calculator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.paypal_link_generator.name' => 'PayPal link generator',
    'tools.paypal_link_generator.description' => 'Generate a paypal payment link with ease.',
    'tools.paypal_link_generator.meta_keywords' => '',
    'tools.paypal_link_generator.type' => 'Type',
    'tools.paypal_link_generator.type.buy_now' => 'Buy now',
    'tools.paypal_link_generator.type.add_to_cart' => 'Add to cart',
    'tools.paypal_link_generator.type.donation' => 'Donation',
    'tools.paypal_link_generator.email' => 'PayPal email',
    'tools.paypal_link_generator.title' => 'Title',
    'tools.paypal_link_generator.currency' => 'Currency code',
    'tools.paypal_link_generator.price' => 'Price',
    'tools.paypal_link_generator.thank_you_url' => 'Thank you URL',
    'tools.paypal_link_generator.cancel_url' => 'Cancel URL',
    'tools.paypal_link_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bbcode_to_html.name' => 'BBCode to HTML',
    'tools.bbcode_to_html.description' => 'Convert forum type bbcode snippets to raw HTML code.',
    'tools.bbcode_to_html.meta_keywords' => '',
    'tools.bbcode_to_html.bbcode' => 'BBCode',
    'tools.bbcode_to_html.html' => 'HTML',
    'tools.bbcode_to_html.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.html_tags_remover.name' => 'HTML tags remover',
    'tools.html_tags_remover.description' => 'Easily remove all HTML tags from a block of text.',
    'tools.html_tags_remover.meta_keywords' => '',
    'tools.html_tags_remover.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.celsius_to_fahrenheit.name' => 'Celsius to Fahrenheit',
    'tools.celsius_to_fahrenheit.description' => 'Convert celsius degrees to fahrenheit degrees with ease.',
    'tools.celsius_to_fahrenheit.meta_keywords' => '',
    'tools.celsius_to_fahrenheit.celsius' => 'Celsius',
    'tools.celsius_to_fahrenheit.fahrenheit' => 'Fahrenheit',
    'tools.celsius_to_fahrenheit.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.celsius_to_kelvin.name' => 'Celsius to Kelvin',
    'tools.celsius_to_kelvin.description' => 'Convert celsius degrees to kelvin degrees with ease.',
    'tools.celsius_to_kelvin.meta_keywords' => '',
    'tools.celsius_to_kelvin.celsius' => 'Celsius',
    'tools.celsius_to_kelvin.kelvin' => 'Kelvin',
    'tools.celsius_to_kelvin.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.fahrenheit_to_celsius.name' => 'Fahrenheit to Celsius',
    'tools.fahrenheit_to_celsius.description' => 'Convert fahrenheit degrees to celsius degrees with ease.',
    'tools.fahrenheit_to_celsius.meta_keywords' => '',
    'tools.fahrenheit_to_celsius.celsius' => 'Celsius',
    'tools.fahrenheit_to_celsius.fahrenheit' => 'Fahrenheit',
    'tools.fahrenheit_to_celsius.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.fahrenheit_to_kelvin.name' => 'Fahrenheit to Kelvin',
    'tools.fahrenheit_to_kelvin.description' => 'Convert fahrenheit degrees to celsius degrees with ease.',
    'tools.fahrenheit_to_kelvin.meta_keywords' => '',
    'tools.fahrenheit_to_kelvin.kelvin' => 'Kelvin',
    'tools.fahrenheit_to_kelvin.fahrenheit' => 'Fahrenheit',
    'tools.fahrenheit_to_kelvin.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kelvin_to_celsius.name' => 'Kelvin to Celsius',
    'tools.kelvin_to_celsius.description' => 'Convert kelvin degrees to celsius degrees with ease.',
    'tools.kelvin_to_celsius.meta_keywords' => '',
    'tools.kelvin_to_celsius.celsius' => 'Celsius',
    'tools.kelvin_to_celsius.kelvin' => 'Kelvin',
    'tools.kelvin_to_celsius.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kelvin_to_fahrenheit.name' => 'Kelvin to Fahrenheit',
    'tools.kelvin_to_fahrenheit.description' => 'Convert kelvin degrees to fahrenheit degrees with ease.',
    'tools.kelvin_to_fahrenheit.meta_keywords' => '',
    'tools.kelvin_to_fahrenheit.kelvin' => 'Kelvin',
    'tools.kelvin_to_fahrenheit.fahrenheit' => 'Fahrenheit',
    'tools.kelvin_to_fahrenheit.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilometers_to_miles.name' => 'Kilometers to Miles',
    'tools.kilometers_to_miles.description' => 'Convert kilometers (km) to miles (mi) with ease.',
    'tools.kilometers_to_miles.meta_keywords' => '',
    'tools.kilometers_to_miles.kilometers' => 'Kilometers',
    'tools.kilometers_to_miles.miles' => 'Miles',
    'tools.kilometers_to_miles.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.miles_to_kilometers.name' => 'Miles to Kilometers',
    'tools.miles_to_kilometers.description' => 'Convert miles (mi) to kilometers (km) with ease.',
    'tools.miles_to_kilometers.meta_keywords' => '',
    'tools.miles_to_kilometers.kilometers' => 'Kilometers',
    'tools.miles_to_kilometers.miles' => 'Miles',
    'tools.miles_to_kilometers.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilometers_per_hour_to_miles_per_hour.name' => 'Kph to Mph',
    'tools.kilometers_per_hour_to_miles_per_hour.description' => 'Convert kilometers per hour (kph) to miles per hour (mph) with ease.',
    'tools.kilometers_per_hour_to_miles_per_hour.meta_keywords' => '',
    'tools.kilometers_per_hour_to_miles_per_hour.kph' => 'Kph',
    'tools.kilometers_per_hour_to_miles_per_hour.mph' => 'Mph',
    'tools.kilometers_per_hour_to_miles_per_hour.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.miles_per_hour_to_kilometers_per_hour.name' => 'Mph to Kph',
    'tools.miles_per_hour_to_kilometers_per_hour.description' => 'Convert miles per hour (mph) to kilometers per hour (kph) with ease.',
    'tools.miles_per_hour_to_kilometers_per_hour.meta_keywords' => '',
    'tools.miles_per_hour_to_kilometers_per_hour.kph' => 'Kph',
    'tools.miles_per_hour_to_kilometers_per_hour.mph' => 'Mph',
    'tools.miles_per_hour_to_kilometers_per_hour.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilograms_to_pounds.name' => 'Kilograms to Pounds',
    'tools.kilograms_to_pounds.description' => 'Convert kilograms (kg) to pounds (lb) with ease.',
    'tools.kilograms_to_pounds.meta_keywords' => '',
    'tools.kilograms_to_pounds.kilograms' => 'Kilograms',
    'tools.kilograms_to_pounds.pounds' => 'Pounds',
    'tools.kilograms_to_pounds.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.pounds_to_kilograms.name' => 'Pounds to Kilograms',
    'tools.pounds_to_kilograms.description' => 'Convert pounds (lb) to kilograms (kg) with ease.',
    'tools.pounds_to_kilograms.meta_keywords' => '',
    'tools.pounds_to_kilograms.pounds' => 'Pounds',
    'tools.pounds_to_kilograms.kilograms' => 'Kilograms',
    'tools.pounds_to_kilograms.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.number_to_roman_numerals.name' => 'Number to Roman Numerals',
    'tools.number_to_roman_numerals.description' => 'Convert a number to roman numerals with ease.',
    'tools.number_to_roman_numerals.meta_keywords' => '',
    'tools.number_to_roman_numerals.number' => 'Number',
    'tools.number_to_roman_numerals.roman_numerals' => 'Roman numerals',
    'tools.number_to_roman_numerals.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.roman_numerals_to_number.name' => 'Roman Numerals to Number',
    'tools.roman_numerals_to_number.description' => 'Convert roman numerals to a number with ease.',
    'tools.roman_numerals_to_number.meta_keywords' => '',
    'tools.roman_numerals_to_number.number' => 'Number',
    'tools.roman_numerals_to_number.roman_numerals' => 'Roman numerals',
    'tools.roman_numerals_to_number.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.liters_to_gallons_us.name' => 'Liters to Gallons (US)',
    'tools.liters_to_gallons_us.description' => 'Convert liters to gallons (US) with ease.',
    'tools.liters_to_gallons_us.meta_keywords' => '',
    'tools.liters_to_gallons_us.liters' => 'Liters',
    'tools.liters_to_gallons_us.gallons' => 'Gallons',
    'tools.liters_to_gallons_us.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.liters_to_gallons_imperial.name' => 'Liters to Gallons (Imperial)',
    'tools.liters_to_gallons_imperial.description' => 'Convert liters to gallons (imperial) with ease.',
    'tools.liters_to_gallons_imperial.meta_keywords' => '',
    'tools.liters_to_gallons_imperial.liters' => 'Liters',
    'tools.liters_to_gallons_imperial.gallons' => 'Gallons',
    'tools.liters_to_gallons_imperial.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gallons_us_to_liters.name' => 'Gallons (US) to Liters',
    'tools.gallons_us_to_liters.description' => 'Convert gallons (US) to liters with ease.',
    'tools.gallons_us_to_liters.meta_keywords' => '',
    'tools.gallons_us_to_liters.liters' => 'Liters',
    'tools.gallons_us_to_liters.gallons' => 'Gallons',
    'tools.gallons_us_to_liters.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.gallons_imperial_to_liters.name' => 'Gallons (Imperial) to Liters',
    'tools.gallons_imperial_to_liters.description' => 'Convert gallons (imperial) to liters with ease.',
    'tools.gallons_imperial_to_liters.meta_keywords' => '',
    'tools.gallons_imperial_to_liters.liters' => 'Liters',
    'tools.gallons_imperial_to_liters.gallons' => 'Gallons',
    'tools.gallons_imperial_to_liters.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.unix_timestamp_to_date.name' => 'Unix Timestamp to Date',
    'tools.unix_timestamp_to_date.description' => 'Convert a unix timestamp to UTC and your local date.',
    'tools.unix_timestamp_to_date.meta_keywords' => '',
    'tools.unix_timestamp_to_date.unix_timestamp' => 'Unix timestamp',
    'tools.unix_timestamp_to_date.utc' => 'UTC',
    'tools.unix_timestamp_to_date.local' => 'Your local timezone',
    'tools.unix_timestamp_to_date.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.date_to_unix_timestamp.name' => 'Date to Unix Timestamp',
    'tools.date_to_unix_timestamp.description' => 'Convert a particular date to the unix timestamp format.',
    'tools.date_to_unix_timestamp.meta_keywords' => '',
    'tools.date_to_unix_timestamp.timezone' => 'Timezone',
    'tools.date_to_unix_timestamp.result' => 'Unix timestamp',
    'tools.date_to_unix_timestamp.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.seconds_to_minutes.name' => 'Seconds to Minutes',
    'tools.seconds_to_minutes.description' => 'Easily convert seconds to minutes.',
    'tools.seconds_to_minutes.meta_keywords' => '',
    'tools.seconds_to_minutes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.seconds_to_hours.name' => 'Seconds to Hours',
    'tools.seconds_to_hours.description' => 'Easily convert seconds to hours.',
    'tools.seconds_to_hours.meta_keywords' => '',
    'tools.seconds_to_hours.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.seconds_to_days.name' => 'Seconds to Days',
    'tools.seconds_to_days.description' => 'Easily convert seconds to days.',
    'tools.seconds_to_days.meta_keywords' => '',
    'tools.seconds_to_days.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.seconds_to_weeks.name' => 'Seconds to Weeks',
    'tools.seconds_to_weeks.description' => 'Easily convert seconds to weeks.',
    'tools.seconds_to_weeks.meta_keywords' => '',
    'tools.seconds_to_weeks.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.seconds_to_months.name' => 'Seconds to Months',
    'tools.seconds_to_months.description' => 'Easily convert seconds to months.',
    'tools.seconds_to_months.meta_keywords' => '',
    'tools.seconds_to_months.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.seconds_to_years.name' => 'Seconds to Years',
    'tools.seconds_to_years.description' => 'Easily convert seconds to years.',
    'tools.seconds_to_years.meta_keywords' => '',
    'tools.seconds_to_years.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.minutes_to_seconds.name' => 'Minutes to Seconds',
    'tools.minutes_to_seconds.description' => 'Easily convert minutes to seconds.',
    'tools.minutes_to_seconds.meta_keywords' => '',
    'tools.minutes_to_seconds.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.minutes_to_hours.name' => 'Minutes to Hours',
    'tools.minutes_to_hours.description' => 'Easily convert minutes to hours.',
    'tools.minutes_to_hours.meta_keywords' => '',
    'tools.minutes_to_hours.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.minutes_to_days.name' => 'Minutes to Days',
    'tools.minutes_to_days.description' => 'Easily convert minutes to days.',
    'tools.minutes_to_days.meta_keywords' => '',
    'tools.minutes_to_days.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.minutes_to_weeks.name' => 'Minutes to Weeks',
    'tools.minutes_to_weeks.description' => 'Easily convert minutes to weeks.',
    'tools.minutes_to_weeks.meta_keywords' => '',
    'tools.minutes_to_weeks.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.minutes_to_months.name' => 'Minutes to Months',
    'tools.minutes_to_months.description' => 'Easily convert minutes to months.',
    'tools.minutes_to_months.meta_keywords' => '',
    'tools.minutes_to_months.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.minutes_to_years.name' => 'Minutes to Years',
    'tools.minutes_to_years.description' => 'Easily convert minutes to years.',
    'tools.minutes_to_years.meta_keywords' => '',
    'tools.minutes_to_years.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hours_to_seconds.name' => 'Hours to Seconds',
    'tools.hours_to_seconds.description' => 'Easily convert hours to seconds.',
    'tools.hours_to_seconds.meta_keywords' => '',
    'tools.hours_to_seconds.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hours_to_minutes.name' => 'Hours to Minutes',
    'tools.hours_to_minutes.description' => 'Easily convert hours to minutes.',
    'tools.hours_to_minutes.meta_keywords' => '',
    'tools.hours_to_minutes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hours_to_days.name' => 'Hours to Days',
    'tools.hours_to_days.description' => 'Easily convert hours to days.',
    'tools.hours_to_days.meta_keywords' => '',
    'tools.hours_to_days.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hours_to_weeks.name' => 'Hours to Weeks',
    'tools.hours_to_weeks.description' => 'Easily convert hours to weeks.',
    'tools.hours_to_weeks.meta_keywords' => '',
    'tools.hours_to_weeks.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hours_to_months.name' => 'Hours to Months',
    'tools.hours_to_months.description' => 'Easily convert hours to months.',
    'tools.hours_to_months.meta_keywords' => '',
    'tools.hours_to_months.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.hours_to_years.name' => 'Hours to Years',
    'tools.hours_to_years.description' => 'Easily convert hours to years.',
    'tools.hours_to_years.meta_keywords' => '',
    'tools.hours_to_years.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.days_to_seconds.name' => 'Days to Seconds',
    'tools.days_to_seconds.description' => 'Easily convert days to seconds.',
    'tools.days_to_seconds.meta_keywords' => '',
    'tools.days_to_seconds.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.days_to_minutes.name' => 'Days to Hours',
    'tools.days_to_minutes.description' => 'Easily convert days to minutes.',
    'tools.days_to_minutes.meta_keywords' => '',
    'tools.days_to_minutes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.days_to_hours.name' => 'Days to Hours',
    'tools.days_to_hours.description' => 'Easily convert days to hours.',
    'tools.days_to_hours.meta_keywords' => '',
    'tools.days_to_hours.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.days_to_weeks.name' => 'Days to Weeks',
    'tools.days_to_weeks.description' => 'Easily convert days to weeks.',
    'tools.days_to_weeks.meta_keywords' => '',
    'tools.days_to_weeks.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.days_to_months.name' => 'Days to Months',
    'tools.days_to_months.description' => 'Easily convert days to months.',
    'tools.days_to_months.meta_keywords' => '',
    'tools.days_to_months.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.days_to_years.name' => 'Days to Years',
    'tools.days_to_years.description' => 'Easily convert days to years.',
    'tools.days_to_years.meta_keywords' => '',
    'tools.days_to_years.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.weeks_to_seconds.name' => 'Weeks to Seconds',
    'tools.weeks_to_seconds.description' => 'Easily convert weeks to seconds.',
    'tools.weeks_to_seconds.meta_keywords' => '',
    'tools.weeks_to_seconds.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.weeks_to_minutes.name' => 'Weeks to Hours',
    'tools.weeks_to_minutes.description' => 'Easily convert weeks to minutes.',
    'tools.weeks_to_minutes.meta_keywords' => '',
    'tools.weeks_to_minutes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.weeks_to_hours.name' => 'Weeks to Hours',
    'tools.weeks_to_hours.description' => 'Easily convert weeks to hours.',
    'tools.weeks_to_hours.meta_keywords' => '',
    'tools.weeks_to_hours.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.weeks_to_days.name' => 'Weeks to Days',
    'tools.weeks_to_days.description' => 'Easily convert weeks to days.',
    'tools.weeks_to_days.meta_keywords' => '',
    'tools.weeks_to_days.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.weeks_to_months.name' => 'Weeks to Months',
    'tools.weeks_to_months.description' => 'Easily convert weeks to months.',
    'tools.weeks_to_months.meta_keywords' => '',
    'tools.weeks_to_months.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.weeks_to_years.name' => 'Weeks to Years',
    'tools.weeks_to_years.description' => 'Easily convert weeks to years.',
    'tools.weeks_to_years.meta_keywords' => '',
    'tools.weeks_to_years.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.months_to_seconds.name' => 'Months to Seconds',
    'tools.months_to_seconds.description' => 'Easily convert months to seconds.',
    'tools.months_to_seconds.meta_keywords' => '',
    'tools.months_to_seconds.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.months_to_minutes.name' => 'Months to Hours',
    'tools.months_to_minutes.description' => 'Easily convert months to minutes.',
    'tools.months_to_minutes.meta_keywords' => '',
    'tools.months_to_minutes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.months_to_hours.name' => 'Months to Hours',
    'tools.months_to_hours.description' => 'Easily convert months to hours.',
    'tools.months_to_hours.meta_keywords' => '',
    'tools.months_to_hours.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.months_to_days.name' => 'Months to Days',
    'tools.months_to_days.description' => 'Easily convert months to days.',
    'tools.months_to_days.meta_keywords' => '',
    'tools.months_to_days.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.months_to_weeks.name' => 'Months to Weeks',
    'tools.months_to_weeks.description' => 'Easily convert months to weeks.',
    'tools.months_to_weeks.meta_keywords' => '',
    'tools.months_to_weeks.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.months_to_years.name' => 'Months to Years',
    'tools.months_to_years.description' => 'Easily convert months to years.',
    'tools.months_to_years.meta_keywords' => '',
    'tools.months_to_years.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.years_to_seconds.name' => 'Years to Seconds',
    'tools.years_to_seconds.description' => 'Easily convert years to seconds.',
    'tools.years_to_seconds.meta_keywords' => '',
    'tools.years_to_seconds.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.years_to_minutes.name' => 'Years to Hours',
    'tools.years_to_minutes.description' => 'Easily convert years to minutes.',
    'tools.years_to_minutes.meta_keywords' => '',
    'tools.years_to_minutes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.years_to_hours.name' => 'Years to Hours',
    'tools.years_to_hours.description' => 'Easily convert years to hours.',
    'tools.years_to_hours.meta_keywords' => '',
    'tools.years_to_hours.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.years_to_days.name' => 'Years to Days',
    'tools.years_to_days.description' => 'Easily convert years to days.',
    'tools.years_to_days.meta_keywords' => '',
    'tools.years_to_days.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.years_to_weeks.name' => 'Years to Weeks',
    'tools.years_to_weeks.description' => 'Easily convert years to weeks.',
    'tools.years_to_weeks.meta_keywords' => '',
    'tools.years_to_weeks.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.years_to_months.name' => 'Years to Months',
    'tools.years_to_months.description' => 'Easily convert years to months.',
    'tools.years_to_months.meta_keywords' => '',
    'tools.years_to_months.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.signature_generator.name' => 'Signature generator',
    'tools.signature_generator.description' => 'Easily generate your own custom signature and download it with ease.',
    'tools.signature_generator.meta_keywords' => '',
    'tools.signature_generator.clear' => 'Clear',
    'tools.signature_generator.undo' => 'Undo',
    'tools.signature_generator.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_nibbles.name' => 'Bits to Nibbles',
    'tools.bits_to_nibbles.description' => 'Easily convert bits (bit) to nibbles.',
    'tools.bits_to_nibbles.meta_keywords' => '',
    'tools.bits_to_nibbles.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_bytes.name' => 'Bits to Bytes',
    'tools.bits_to_bytes.description' => 'Easily convert bits (bit) to bytes (B).',
    'tools.bits_to_bytes.meta_keywords' => '',
    'tools.bits_to_bytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_kilobits.name' => 'Bits to Kilobits',
    'tools.bits_to_kilobits.description' => 'Easily convert bits (bit) to kilobits (kbit).',
    'tools.bits_to_kilobits.meta_keywords' => '',
    'tools.bits_to_kilobits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_kibibits.name' => 'Bits to Kibibits',
    'tools.bits_to_kibibits.description' => 'Easily convert bits (bit) to kibibits (Kibit).',
    'tools.bits_to_kibibits.meta_keywords' => '',
    'tools.bits_to_kibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_kilobytes.name' => 'Bits to Kilobytes',
    'tools.bits_to_kilobytes.description' => 'Easily convert bits (bit) to kilobytes (kB).',
    'tools.bits_to_kilobytes.meta_keywords' => '',
    'tools.bits_to_kilobytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_kibibytes.name' => 'Bits to Kibibytes',
    'tools.bits_to_kibibytes.description' => 'Easily convert bits (bit) to kibibytes (KiB).',
    'tools.bits_to_kibibytes.meta_keywords' => '',
    'tools.bits_to_kibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_megabits.name' => 'Bits to Megabits',
    'tools.bits_to_megabits.description' => 'Easily convert bits (bit) to megabits (Mbit).',
    'tools.bits_to_megabits.meta_keywords' => '',
    'tools.bits_to_megabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_mebibits.name' => 'Bits to Mebibits',
    'tools.bits_to_mebibits.description' => 'Easily convert bits (bit) to mebibits (Mibit).',
    'tools.bits_to_mebibits.meta_keywords' => '',
    'tools.bits_to_mebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_megabytes.name' => 'Bits to Megabytes',
    'tools.bits_to_megabytes.description' => 'Easily convert bits (bit) to megabytes (MB).',
    'tools.bits_to_megabytes.meta_keywords' => '',
    'tools.bits_to_megabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_mebibytes.name' => 'Bits to Mebibytes',
    'tools.bits_to_mebibytes.description' => 'Easily convert bits (bit) to mebibytes (MiB).',
    'tools.bits_to_mebibytes.meta_keywords' => '',
    'tools.bits_to_mebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_gigabits.name' => 'Bits to Gigabits',
    'tools.bits_to_gigabits.description' => 'Easily convert bits (bit) to gigabits (Gbit).',
    'tools.bits_to_gigabits.meta_keywords' => '',
    'tools.bits_to_gigabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_gibibits.name' => 'Bits to Gibibits',
    'tools.bits_to_gibibits.description' => 'Easily convert bits (bit) to gibibits (Gibit).',
    'tools.bits_to_gibibits.meta_keywords' => '',
    'tools.bits_to_gibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_gigabytes.name' => 'Bits to Gigabytes',
    'tools.bits_to_gigabytes.description' => 'Easily convert bits (bit) to gigabytes (GB).',
    'tools.bits_to_gigabytes.meta_keywords' => '',
    'tools.bits_to_gigabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_gibibytes.name' => 'Bits to Gibibytes',
    'tools.bits_to_gibibytes.description' => 'Easily convert bits (bit) to gibibytes (GiB).',
    'tools.bits_to_gibibytes.meta_keywords' => '',
    'tools.bits_to_gibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_terabits.name' => 'Bits to Terabits',
    'tools.bits_to_terabits.description' => 'Easily convert bits (bit) to terabits (Tbit).',
    'tools.bits_to_terabits.meta_keywords' => '',
    'tools.bits_to_terabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_tebibits.name' => 'Bits to Tebibits',
    'tools.bits_to_tebibits.description' => 'Easily convert bits (bit) to tebibits (Tibit).',
    'tools.bits_to_tebibits.meta_keywords' => '',
    'tools.bits_to_tebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_terabytes.name' => 'Bits to Terabytes',
    'tools.bits_to_terabytes.description' => 'Easily convert bits (bit) to terabytes (TB).',
    'tools.bits_to_terabytes.meta_keywords' => '',
    'tools.bits_to_terabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_tebibytes.name' => 'Bits to Tebibytes',
    'tools.bits_to_tebibytes.description' => 'Easily convert bits (bit) to tebibytes (TiB).',
    'tools.bits_to_tebibytes.meta_keywords' => '',
    'tools.bits_to_tebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_petabits.name' => 'Bits to Petabits',
    'tools.bits_to_petabits.description' => 'Easily convert bits (bit) to petabits (Pbit).',
    'tools.bits_to_petabits.meta_keywords' => '',
    'tools.bits_to_petabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_pebibits.name' => 'Bits to Pebibits',
    'tools.bits_to_pebibits.description' => 'Easily convert bits (bit) to pebibits (Pibit).',
    'tools.bits_to_pebibits.meta_keywords' => '',
    'tools.bits_to_pebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_petabytes.name' => 'Bits to Petabytes',
    'tools.bits_to_petabytes.description' => 'Easily convert bits (bit) to petabytes (PB).',
    'tools.bits_to_petabytes.meta_keywords' => '',
    'tools.bits_to_petabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_pebibytes.name' => 'Bits to Pebibytes',
    'tools.bits_to_pebibytes.description' => 'Easily convert bits (bit) to pebibytes (PiB).',
    'tools.bits_to_pebibytes.meta_keywords' => '',
    'tools.bits_to_pebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_exabits.name' => 'Bits to Exabits',
    'tools.bits_to_exabits.description' => 'Easily convert bits (bit) to exabits (Ebit).',
    'tools.bits_to_exabits.meta_keywords' => '',
    'tools.bits_to_exabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_exbibits.name' => 'Bits to Exbibits',
    'tools.bits_to_exbibits.description' => 'Easily convert bits (bit) to exbibits (Eibit).',
    'tools.bits_to_exbibits.meta_keywords' => '',
    'tools.bits_to_exbibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_exabytes.name' => 'Bits to Exabytes',
    'tools.bits_to_exabytes.description' => 'Easily convert bits (bit) to exabytes (EB).',
    'tools.bits_to_exabytes.meta_keywords' => '',
    'tools.bits_to_exabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_exbibytes.name' => 'Bits to Exbibytes',
    'tools.bits_to_exbibytes.description' => 'Easily convert bits (bit) to exbibytes (EiB).',
    'tools.bits_to_exbibytes.meta_keywords' => '',
    'tools.bits_to_exbibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_zettabits.name' => 'Bits to Zettabits',
    'tools.bits_to_zettabits.description' => 'Easily convert bits (bit) to zettabits (Zbit).',
    'tools.bits_to_zettabits.meta_keywords' => '',
    'tools.bits_to_zettabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_zebibits.name' => 'Bits to Zebibits',
    'tools.bits_to_zebibits.description' => 'Easily convert bits (bit) to zebibits (Zibit).',
    'tools.bits_to_zebibits.meta_keywords' => '',
    'tools.bits_to_zebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_zettabytes.name' => 'Bits to Zettabytes',
    'tools.bits_to_zettabytes.description' => 'Easily convert bits (bit) to zettabytes (ZB).',
    'tools.bits_to_zettabytes.meta_keywords' => '',
    'tools.bits_to_zettabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_zebibytes.name' => 'Bits to Zebibytes',
    'tools.bits_to_zebibytes.description' => 'Easily convert bits (bit) to zebibytes (ZiB).',
    'tools.bits_to_zebibytes.meta_keywords' => '',
    'tools.bits_to_zebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_yottabits.name' => 'Bits to Yottabits',
    'tools.bits_to_yottabits.description' => 'Easily convert bits (bit) to yottabits (Ybit).',
    'tools.bits_to_yottabits.meta_keywords' => '',
    'tools.bits_to_yottabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_yobibits.name' => 'Bits to Yobibits',
    'tools.bits_to_yobibits.description' => 'Easily convert bits (bit) to yobibits (Yibit).',
    'tools.bits_to_yobibits.meta_keywords' => '',
    'tools.bits_to_yobibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_yottabytes.name' => 'Bits to Yottabytes',
    'tools.bits_to_yottabytes.description' => 'Easily convert bits (bit) to yottabytes (YB).',
    'tools.bits_to_yottabytes.meta_keywords' => '',
    'tools.bits_to_yottabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bits_to_yobibytes.name' => 'Bits to Yobibytes',
    'tools.bits_to_yobibytes.description' => 'Easily convert bits (bit) to yobibytes (YiB).',
    'tools.bits_to_yobibytes.meta_keywords' => '',
    'tools.bits_to_yobibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_bits.name' => 'Nibbles to Bits',
    'tools.nibbles_to_bits.description' => 'Easily convert nibbles to bits (bit).',
    'tools.nibbles_to_bits.meta_keywords' => '',
    'tools.nibbles_to_bits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_bytes.name' => 'Nibbles to Bytes',
    'tools.nibbles_to_bytes.description' => 'Easily convert nibbles to bytes (B).',
    'tools.nibbles_to_bytes.meta_keywords' => '',
    'tools.nibbles_to_bytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_kilobits.name' => 'Nibbles to Kilobits',
    'tools.nibbles_to_kilobits.description' => 'Easily convert nibbles to kilobits (kbit).',
    'tools.nibbles_to_kilobits.meta_keywords' => '',
    'tools.nibbles_to_kilobits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_kibibits.name' => 'Nibbles to Kibibits',
    'tools.nibbles_to_kibibits.description' => 'Easily convert nibbles to kibibits (Kibit).',
    'tools.nibbles_to_kibibits.meta_keywords' => '',
    'tools.nibbles_to_kibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_kilobytes.name' => 'Nibbles to Kilobytes',
    'tools.nibbles_to_kilobytes.description' => 'Easily convert nibbles to kilobytes (kB).',
    'tools.nibbles_to_kilobytes.meta_keywords' => '',
    'tools.nibbles_to_kilobytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_kibibytes.name' => 'Nibbles to Kibibytes',
    'tools.nibbles_to_kibibytes.description' => 'Easily convert nibbles to kibibytes (KiB).',
    'tools.nibbles_to_kibibytes.meta_keywords' => '',
    'tools.nibbles_to_kibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_megabits.name' => 'Nibbles to Megabits',
    'tools.nibbles_to_megabits.description' => 'Easily convert nibbles to megabits (Mbit).',
    'tools.nibbles_to_megabits.meta_keywords' => '',
    'tools.nibbles_to_megabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_mebibits.name' => 'Nibbles to Mebibits',
    'tools.nibbles_to_mebibits.description' => 'Easily convert nibbles to mebibits (Mibit).',
    'tools.nibbles_to_mebibits.meta_keywords' => '',
    'tools.nibbles_to_mebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_megabytes.name' => 'Nibbles to Megabytes',
    'tools.nibbles_to_megabytes.description' => 'Easily convert nibbles to megabytes (MB).',
    'tools.nibbles_to_megabytes.meta_keywords' => '',
    'tools.nibbles_to_megabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_mebibytes.name' => 'Nibbles to Mebibytes',
    'tools.nibbles_to_mebibytes.description' => 'Easily convert nibbles to mebibytes (MiB).',
    'tools.nibbles_to_mebibytes.meta_keywords' => '',
    'tools.nibbles_to_mebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_gigabits.name' => 'Nibbles to Gigabits',
    'tools.nibbles_to_gigabits.description' => 'Easily convert nibbles to gigabits (Gbit).',
    'tools.nibbles_to_gigabits.meta_keywords' => '',
    'tools.nibbles_to_gigabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_gibibits.name' => 'Nibbles to Gibibits',
    'tools.nibbles_to_gibibits.description' => 'Easily convert nibbles to gibibits (Gibit).',
    'tools.nibbles_to_gibibits.meta_keywords' => '',
    'tools.nibbles_to_gibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_gigabytes.name' => 'Nibbles to Gigabytes',
    'tools.nibbles_to_gigabytes.description' => 'Easily convert nibbles to gigabytes (GB).',
    'tools.nibbles_to_gigabytes.meta_keywords' => '',
    'tools.nibbles_to_gigabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_gibibytes.name' => 'Nibbles to Gibibytes',
    'tools.nibbles_to_gibibytes.description' => 'Easily convert nibbles to gibibytes (GiB).',
    'tools.nibbles_to_gibibytes.meta_keywords' => '',
    'tools.nibbles_to_gibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_terabits.name' => 'Nibbles to Terabits',
    'tools.nibbles_to_terabits.description' => 'Easily convert nibbles to terabits (Tbit).',
    'tools.nibbles_to_terabits.meta_keywords' => '',
    'tools.nibbles_to_terabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_tebibits.name' => 'Nibbles to Tebibits',
    'tools.nibbles_to_tebibits.description' => 'Easily convert nibbles to tebibits (Tibit).',
    'tools.nibbles_to_tebibits.meta_keywords' => '',
    'tools.nibbles_to_tebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_terabytes.name' => 'Nibbles to Terabytes',
    'tools.nibbles_to_terabytes.description' => 'Easily convert nibbles to terabytes (TB).',
    'tools.nibbles_to_terabytes.meta_keywords' => '',
    'tools.nibbles_to_terabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_tebibytes.name' => 'Nibbles to Tebibytes',
    'tools.nibbles_to_tebibytes.description' => 'Easily convert nibbles to tebibytes (TiB).',
    'tools.nibbles_to_tebibytes.meta_keywords' => '',
    'tools.nibbles_to_tebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_petabits.name' => 'Nibbles to Petabits',
    'tools.nibbles_to_petabits.description' => 'Easily convert nibbles to petabits (Pbit).',
    'tools.nibbles_to_petabits.meta_keywords' => '',
    'tools.nibbles_to_petabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_pebibits.name' => 'Nibbles to Pebibits',
    'tools.nibbles_to_pebibits.description' => 'Easily convert nibbles to pebibits (Pibit).',
    'tools.nibbles_to_pebibits.meta_keywords' => '',
    'tools.nibbles_to_pebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_petabytes.name' => 'Nibbles to Petabytes',
    'tools.nibbles_to_petabytes.description' => 'Easily convert nibbles to petabytes (PB).',
    'tools.nibbles_to_petabytes.meta_keywords' => '',
    'tools.nibbles_to_petabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_pebibytes.name' => 'Nibbles to Pebibytes',
    'tools.nibbles_to_pebibytes.description' => 'Easily convert nibbles to pebibytes (PiB).',
    'tools.nibbles_to_pebibytes.meta_keywords' => '',
    'tools.nibbles_to_pebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_exabits.name' => 'Nibbles to Exabits',
    'tools.nibbles_to_exabits.description' => 'Easily convert nibbles to exabits (Ebit).',
    'tools.nibbles_to_exabits.meta_keywords' => '',
    'tools.nibbles_to_exabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_exbibits.name' => 'Nibbles to Exbibits',
    'tools.nibbles_to_exbibits.description' => 'Easily convert nibbles to exbibits (Eibit).',
    'tools.nibbles_to_exbibits.meta_keywords' => '',
    'tools.nibbles_to_exbibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_exabytes.name' => 'Nibbles to Exabytes',
    'tools.nibbles_to_exabytes.description' => 'Easily convert nibbles to exabytes (EB).',
    'tools.nibbles_to_exabytes.meta_keywords' => '',
    'tools.nibbles_to_exabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_exbibytes.name' => 'Nibbles to Exbibytes',
    'tools.nibbles_to_exbibytes.description' => 'Easily convert nibbles to exbibytes (EiB).',
    'tools.nibbles_to_exbibytes.meta_keywords' => '',
    'tools.nibbles_to_exbibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_zettabits.name' => 'Nibbles to Zettabits',
    'tools.nibbles_to_zettabits.description' => 'Easily convert nibbles to zettabits (Zbit).',
    'tools.nibbles_to_zettabits.meta_keywords' => '',
    'tools.nibbles_to_zettabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_zebibits.name' => 'Nibbles to Zebibits',
    'tools.nibbles_to_zebibits.description' => 'Easily convert nibbles to zebibits (Zibit).',
    'tools.nibbles_to_zebibits.meta_keywords' => '',
    'tools.nibbles_to_zebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_zettabytes.name' => 'Nibbles to Zettabytes',
    'tools.nibbles_to_zettabytes.description' => 'Easily convert nibbles to zettabytes (ZB).',
    'tools.nibbles_to_zettabytes.meta_keywords' => '',
    'tools.nibbles_to_zettabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_zebibytes.name' => 'Nibbles to Zebibytes',
    'tools.nibbles_to_zebibytes.description' => 'Easily convert nibbles to zebibytes (ZiB).',
    'tools.nibbles_to_zebibytes.meta_keywords' => '',
    'tools.nibbles_to_zebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_yottabits.name' => 'Nibbles to Yottabits',
    'tools.nibbles_to_yottabits.description' => 'Easily convert nibbles to yottabits (Ybit).',
    'tools.nibbles_to_yottabits.meta_keywords' => '',
    'tools.nibbles_to_yottabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_yobibits.name' => 'Nibbles to Yobibits',
    'tools.nibbles_to_yobibits.description' => 'Easily convert nibbles to yobibits (Yibit).',
    'tools.nibbles_to_yobibits.meta_keywords' => '',
    'tools.nibbles_to_yobibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_yottabytes.name' => 'Nibbles to Yottabytes',
    'tools.nibbles_to_yottabytes.description' => 'Easily convert nibbles to yottabytes (YB).',
    'tools.nibbles_to_yottabytes.meta_keywords' => '',
    'tools.nibbles_to_yottabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.nibbles_to_yobibytes.name' => 'Nibbles to Yobibytes',
    'tools.nibbles_to_yobibytes.description' => 'Easily convert nibbles to yobibytes (YiB).',
    'tools.nibbles_to_yobibytes.meta_keywords' => '',
    'tools.nibbles_to_yobibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_bits.name' => 'Bytes to Bits',
    'tools.bytes_to_bits.description' => 'Easily convert bytes (B) to bits (b).',
    'tools.bytes_to_bits.meta_keywords' => '',
    'tools.bytes_to_bits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_nibbles.name' => 'Bytes to Bits',
    'tools.bytes_to_nibbles.description' => 'Easily convert bytes (B) to nibbles.',
    'tools.bytes_to_nibbles.meta_keywords' => '',
    'tools.bytes_to_nibbles.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_kilobits.name' => 'Bytes to Kilobits',
    'tools.bytes_to_kilobits.description' => 'Easily convert bytes (B) to kilobits (kbit).',
    'tools.bytes_to_kilobits.meta_keywords' => '',
    'tools.bytes_to_kilobits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_kibibits.name' => 'Bytes to Kibibits',
    'tools.bytes_to_kibibits.description' => 'Easily convert bytes (B) to kibibits (Kibit).',
    'tools.bytes_to_kibibits.meta_keywords' => '',
    'tools.bytes_to_kibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_kilobytes.name' => 'Bytes to Kilobytes',
    'tools.bytes_to_kilobytes.description' => 'Easily convert bytes (B) to kilobytes (kB).',
    'tools.bytes_to_kilobytes.meta_keywords' => '',
    'tools.bytes_to_kilobytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_kibibytes.name' => 'Bytes to Kibibytes',
    'tools.bytes_to_kibibytes.description' => 'Easily convert bytes (B) to kibibytes (KiB).',
    'tools.bytes_to_kibibytes.meta_keywords' => '',
    'tools.bytes_to_kibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_megabits.name' => 'Bytes to Megabits',
    'tools.bytes_to_megabits.description' => 'Easily convert bytes (B) to megabits (Mbit).',
    'tools.bytes_to_megabits.meta_keywords' => '',
    'tools.bytes_to_megabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_mebibits.name' => 'Bytes to Mebibits',
    'tools.bytes_to_mebibits.description' => 'Easily convert bytes (B) to mebibits (Mibit).',
    'tools.bytes_to_mebibits.meta_keywords' => '',
    'tools.bytes_to_mebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_megabytes.name' => 'Bytes to Megabytes',
    'tools.bytes_to_megabytes.description' => 'Easily convert bytes (B) to megabytes (MB).',
    'tools.bytes_to_megabytes.meta_keywords' => '',
    'tools.bytes_to_megabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_mebibytes.name' => 'Bytes to Mebibytes',
    'tools.bytes_to_mebibytes.description' => 'Easily convert bytes (B) to mebibytes (MiB).',
    'tools.bytes_to_mebibytes.meta_keywords' => '',
    'tools.bytes_to_mebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_gigabits.name' => 'Bytes to Gigabits',
    'tools.bytes_to_gigabits.description' => 'Easily convert bytes (B) to gigabits (Gbit).',
    'tools.bytes_to_gigabits.meta_keywords' => '',
    'tools.bytes_to_gigabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_gibibits.name' => 'Bytes to Gibibits',
    'tools.bytes_to_gibibits.description' => 'Easily convert bytes (B) to gibibits (Gibit).',
    'tools.bytes_to_gibibits.meta_keywords' => '',
    'tools.bytes_to_gibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_gigabytes.name' => 'Bytes to Gigabytes',
    'tools.bytes_to_gigabytes.description' => 'Easily convert bytes (B) to gigabytes (GB).',
    'tools.bytes_to_gigabytes.meta_keywords' => '',
    'tools.bytes_to_gigabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_gibibytes.name' => 'Bytes to Gibibytes',
    'tools.bytes_to_gibibytes.description' => 'Easily convert bytes (B) to gibibytes (GiB).',
    'tools.bytes_to_gibibytes.meta_keywords' => '',
    'tools.bytes_to_gibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_terabits.name' => 'Bytes to Terabits',
    'tools.bytes_to_terabits.description' => 'Easily convert bytes (B) to terabits (Tbit).',
    'tools.bytes_to_terabits.meta_keywords' => '',
    'tools.bytes_to_terabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_tebibits.name' => 'Bytes to Tebibits',
    'tools.bytes_to_tebibits.description' => 'Easily convert bytes (B) to tebibits (Tibit).',
    'tools.bytes_to_tebibits.meta_keywords' => '',
    'tools.bytes_to_tebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_terabytes.name' => 'Bytes to Terabytes',
    'tools.bytes_to_terabytes.description' => 'Easily convert bytes (B) to terabytes (TB).',
    'tools.bytes_to_terabytes.meta_keywords' => '',
    'tools.bytes_to_terabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_tebibytes.name' => 'Bytes to Tebibytes',
    'tools.bytes_to_tebibytes.description' => 'Easily convert bytes (B) to tebibytes (TiB).',
    'tools.bytes_to_tebibytes.meta_keywords' => '',
    'tools.bytes_to_tebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_petabits.name' => 'Bytes to Petabits',
    'tools.bytes_to_petabits.description' => 'Easily convert bytes (B) to petabits (Pbit).',
    'tools.bytes_to_petabits.meta_keywords' => '',
    'tools.bytes_to_petabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_pebibits.name' => 'Bytes to Pebibits',
    'tools.bytes_to_pebibits.description' => 'Easily convert bytes (B) to pebibits (Pibit).',
    'tools.bytes_to_pebibits.meta_keywords' => '',
    'tools.bytes_to_pebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_petabytes.name' => 'Bytes to Petabytes',
    'tools.bytes_to_petabytes.description' => 'Easily convert bytes (B) to petabytes (PB).',
    'tools.bytes_to_petabytes.meta_keywords' => '',
    'tools.bytes_to_petabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_pebibytes.name' => 'Bytes to Pebibytes',
    'tools.bytes_to_pebibytes.description' => 'Easily convert bytes (B) to pebibytes (PiB).',
    'tools.bytes_to_pebibytes.meta_keywords' => '',
    'tools.bytes_to_pebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_exabits.name' => 'Bytes to Exabits',
    'tools.bytes_to_exabits.description' => 'Easily convert bytes (B) to exabits (Ebit).',
    'tools.bytes_to_exabits.meta_keywords' => '',
    'tools.bytes_to_exabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_exbibits.name' => 'Bytes to Exbibits',
    'tools.bytes_to_exbibits.description' => 'Easily convert bytes (B) to exbibits (Eibit).',
    'tools.bytes_to_exbibits.meta_keywords' => '',
    'tools.bytes_to_exbibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_exabytes.name' => 'Bytes to Exabytes',
    'tools.bytes_to_exabytes.description' => 'Easily convert bytes (B) to exabytes (EB).',
    'tools.bytes_to_exabytes.meta_keywords' => '',
    'tools.bytes_to_exabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_exbibytes.name' => 'Bytes to Exbibytes',
    'tools.bytes_to_exbibytes.description' => 'Easily convert bytes (B) to exbibytes (EiB).',
    'tools.bytes_to_exbibytes.meta_keywords' => '',
    'tools.bytes_to_exbibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_zettabits.name' => 'Bytes to Zettabits',
    'tools.bytes_to_zettabits.description' => 'Easily convert bytes (B) to zettabits (Zbit).',
    'tools.bytes_to_zettabits.meta_keywords' => '',
    'tools.bytes_to_zettabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_zebibits.name' => 'Bytes to Zebibits',
    'tools.bytes_to_zebibits.description' => 'Easily convert bytes (B) to zebibits (Zibit).',
    'tools.bytes_to_zebibits.meta_keywords' => '',
    'tools.bytes_to_zebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_zettabytes.name' => 'Bytes to Zettabytes',
    'tools.bytes_to_zettabytes.description' => 'Easily convert bytes (B) to zettabytes (ZB).',
    'tools.bytes_to_zettabytes.meta_keywords' => '',
    'tools.bytes_to_zettabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_zebibytes.name' => 'Bytes to Zebibytes',
    'tools.bytes_to_zebibytes.description' => 'Easily convert bytes (B) to zebibytes (ZiB).',
    'tools.bytes_to_zebibytes.meta_keywords' => '',
    'tools.bytes_to_zebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_yottabits.name' => 'Bytes to Yottabits',
    'tools.bytes_to_yottabits.description' => 'Easily convert bytes (B) to yottabits (Ybit).',
    'tools.bytes_to_yottabits.meta_keywords' => '',
    'tools.bytes_to_yottabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_yobibits.name' => 'Bytes to Yobibits',
    'tools.bytes_to_yobibits.description' => 'Easily convert bytes (B) to yobibits (Yibit).',
    'tools.bytes_to_yobibits.meta_keywords' => '',
    'tools.bytes_to_yobibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_yottabytes.name' => 'Bytes to Yottabytes',
    'tools.bytes_to_yottabytes.description' => 'Easily convert bytes (B) to yottabytes (YB).',
    'tools.bytes_to_yottabytes.meta_keywords' => '',
    'tools.bytes_to_yottabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.bytes_to_yobibytes.name' => 'Bytes to Yobibytes',
    'tools.bytes_to_yobibytes.description' => 'Easily convert bytes (B) to yobibytes (YiB).',
    'tools.bytes_to_yobibytes.meta_keywords' => '',
    'tools.bytes_to_yobibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_bits.name' => 'Kilobits to Bits',
    'tools.kilobits_to_bits.description' => 'Easily convert kilobits (kbit) to bits (b).',
    'tools.kilobits_to_bits.meta_keywords' => '',
    'tools.kilobits_to_bits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_nibbles.name' => 'Kilobits to Bits',
    'tools.kilobits_to_nibbles.description' => 'Easily convert kilobits (kbit) to nibbles.',
    'tools.kilobits_to_nibbles.meta_keywords' => '',
    'tools.kilobits_to_nibbles.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_bytes.name' => 'Kilobits to Bytes',
    'tools.kilobits_to_bytes.description' => 'Easily convert kilobits (kbit) to bytes (B).',
    'tools.kilobits_to_bytes.meta_keywords' => '',
    'tools.kilobits_to_bytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_kibibits.name' => 'Kilobits to Kibibits',
    'tools.kilobits_to_kibibits.description' => 'Easily convert kilobits (kbit) to kibibits (Kibit).',
    'tools.kilobits_to_kibibits.meta_keywords' => '',
    'tools.kilobits_to_kibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_kilobytes.name' => 'Kilobits to Kilobytes',
    'tools.kilobits_to_kilobytes.description' => 'Easily convert kilobits (kbit) to kilobytes (kB).',
    'tools.kilobits_to_kilobytes.meta_keywords' => '',
    'tools.kilobits_to_kilobytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_kibibytes.name' => 'Kilobits to Kibibytes',
    'tools.kilobits_to_kibibytes.description' => 'Easily convert kilobits (kbit) to kibibytes (KiB).',
    'tools.kilobits_to_kibibytes.meta_keywords' => '',
    'tools.kilobits_to_kibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_megabits.name' => 'Kilobits to Megabits',
    'tools.kilobits_to_megabits.description' => 'Easily convert kilobits (kbit) to megabits (Mbit).',
    'tools.kilobits_to_megabits.meta_keywords' => '',
    'tools.kilobits_to_megabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_mebibits.name' => 'Kilobits to Mebibits',
    'tools.kilobits_to_mebibits.description' => 'Easily convert kilobits (kbit) to mebibits (Mibit).',
    'tools.kilobits_to_mebibits.meta_keywords' => '',
    'tools.kilobits_to_mebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_megabytes.name' => 'Kilobits to Megabytes',
    'tools.kilobits_to_megabytes.description' => 'Easily convert kilobits (kbit) to megabytes (MB).',
    'tools.kilobits_to_megabytes.meta_keywords' => '',
    'tools.kilobits_to_megabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_mebibytes.name' => 'Kilobits to Mebibytes',
    'tools.kilobits_to_mebibytes.description' => 'Easily convert kilobits (kbit) to mebibytes (MiB).',
    'tools.kilobits_to_mebibytes.meta_keywords' => '',
    'tools.kilobits_to_mebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_gigabits.name' => 'Kilobits to Gigabits',
    'tools.kilobits_to_gigabits.description' => 'Easily convert kilobits (kbit) to gigabits (Gbit).',
    'tools.kilobits_to_gigabits.meta_keywords' => '',
    'tools.kilobits_to_gigabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_gibibits.name' => 'Kilobits to Gibibits',
    'tools.kilobits_to_gibibits.description' => 'Easily convert kilobits (kbit) to gibibits (Gibit).',
    'tools.kilobits_to_gibibits.meta_keywords' => '',
    'tools.kilobits_to_gibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_gigabytes.name' => 'Kilobits to Gigabytes',
    'tools.kilobits_to_gigabytes.description' => 'Easily convert kilobits (kbit) to gigabytes (GB).',
    'tools.kilobits_to_gigabytes.meta_keywords' => '',
    'tools.kilobits_to_gigabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_gibibytes.name' => 'Kilobits to Gibibytes',
    'tools.kilobits_to_gibibytes.description' => 'Easily convert kilobits (kbit) to gibibytes (GiB).',
    'tools.kilobits_to_gibibytes.meta_keywords' => '',
    'tools.kilobits_to_gibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_terabits.name' => 'Kilobits to Terabits',
    'tools.kilobits_to_terabits.description' => 'Easily convert kilobits (kbit) to terabits (Tbit).',
    'tools.kilobits_to_terabits.meta_keywords' => '',
    'tools.kilobits_to_terabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_tebibits.name' => 'Kilobits to Tebibits',
    'tools.kilobits_to_tebibits.description' => 'Easily convert kilobits (kbit) to tebibits (Tibit).',
    'tools.kilobits_to_tebibits.meta_keywords' => '',
    'tools.kilobits_to_tebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_terabytes.name' => 'Kilobits to Terabytes',
    'tools.kilobits_to_terabytes.description' => 'Easily convert kilobits (kbit) to terabytes (TB).',
    'tools.kilobits_to_terabytes.meta_keywords' => '',
    'tools.kilobits_to_terabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_tebibytes.name' => 'Kilobits to Tebibytes',
    'tools.kilobits_to_tebibytes.description' => 'Easily convert kilobits (kbit) to tebibytes (TiB).',
    'tools.kilobits_to_tebibytes.meta_keywords' => '',
    'tools.kilobits_to_tebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_petabits.name' => 'Kilobits to Petabits',
    'tools.kilobits_to_petabits.description' => 'Easily convert kilobits (kbit) to petabits (Pbit).',
    'tools.kilobits_to_petabits.meta_keywords' => '',
    'tools.kilobits_to_petabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_pebibits.name' => 'Kilobits to Pebibits',
    'tools.kilobits_to_pebibits.description' => 'Easily convert kilobits (kbit) to pebibits (Pibit).',
    'tools.kilobits_to_pebibits.meta_keywords' => '',
    'tools.kilobits_to_pebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_petabytes.name' => 'Kilobits to Petabytes',
    'tools.kilobits_to_petabytes.description' => 'Easily convert kilobits (kbit) to petabytes (PB).',
    'tools.kilobits_to_petabytes.meta_keywords' => '',
    'tools.kilobits_to_petabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_pebibytes.name' => 'Kilobits to Pebibytes',
    'tools.kilobits_to_pebibytes.description' => 'Easily convert kilobits (kbit) to pebibytes (PiB).',
    'tools.kilobits_to_pebibytes.meta_keywords' => '',
    'tools.kilobits_to_pebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_exabits.name' => 'Kilobits to Exabits',
    'tools.kilobits_to_exabits.description' => 'Easily convert kilobits (kbit) to exabits (Ebit).',
    'tools.kilobits_to_exabits.meta_keywords' => '',
    'tools.kilobits_to_exabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_exbibits.name' => 'Kilobits to Exbibits',
    'tools.kilobits_to_exbibits.description' => 'Easily convert kilobits (kbit) to exbibits (Eibit).',
    'tools.kilobits_to_exbibits.meta_keywords' => '',
    'tools.kilobits_to_exbibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_exabytes.name' => 'Kilobits to Exabytes',
    'tools.kilobits_to_exabytes.description' => 'Easily convert kilobits (kbit) to exabytes (EB).',
    'tools.kilobits_to_exabytes.meta_keywords' => '',
    'tools.kilobits_to_exabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_exbibytes.name' => 'Kilobits to Exbibytes',
    'tools.kilobits_to_exbibytes.description' => 'Easily convert kilobits (kbit) to exbibytes (EiB).',
    'tools.kilobits_to_exbibytes.meta_keywords' => '',
    'tools.kilobits_to_exbibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_zettabits.name' => 'Kilobits to Zettabits',
    'tools.kilobits_to_zettabits.description' => 'Easily convert kilobits (kbit) to zettabits (Zbit).',
    'tools.kilobits_to_zettabits.meta_keywords' => '',
    'tools.kilobits_to_zettabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_zebibits.name' => 'Kilobits to Zebibits',
    'tools.kilobits_to_zebibits.description' => 'Easily convert kilobits (kbit) to zebibits (Zibit).',
    'tools.kilobits_to_zebibits.meta_keywords' => '',
    'tools.kilobits_to_zebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_zettabytes.name' => 'Kilobits to Zettabytes',
    'tools.kilobits_to_zettabytes.description' => 'Easily convert kilobits (kbit) to zettabytes (ZB).',
    'tools.kilobits_to_zettabytes.meta_keywords' => '',
    'tools.kilobits_to_zettabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_zebibytes.name' => 'Kilobits to Zebibytes',
    'tools.kilobits_to_zebibytes.description' => 'Easily convert kilobits (kbit) to zebibytes (ZiB).',
    'tools.kilobits_to_zebibytes.meta_keywords' => '',
    'tools.kilobits_to_zebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_yottabits.name' => 'Kilobits to Yottabits',
    'tools.kilobits_to_yottabits.description' => 'Easily convert kilobits (kbit) to yottabits (Ybit).',
    'tools.kilobits_to_yottabits.meta_keywords' => '',
    'tools.kilobits_to_yottabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_yobibits.name' => 'Kilobits to Yobibits',
    'tools.kilobits_to_yobibits.description' => 'Easily convert kilobits (kbit) to yobibits (Yibit).',
    'tools.kilobits_to_yobibits.meta_keywords' => '',
    'tools.kilobits_to_yobibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_yottabytes.name' => 'Kilobits to Yottabytes',
    'tools.kilobits_to_yottabytes.description' => 'Easily convert kilobits (kbit) to yottabytes (YB).',
    'tools.kilobits_to_yottabytes.meta_keywords' => '',
    'tools.kilobits_to_yottabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobits_to_yobibytes.name' => 'Kilobits to Yobibytes',
    'tools.kilobits_to_yobibytes.description' => 'Easily convert kilobits (kbit) to yobibytes (YiB).',
    'tools.kilobits_to_yobibytes.meta_keywords' => '',
    'tools.kilobits_to_yobibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_bits.name' => 'Kibibits to Bits',
    'tools.kibibits_to_bits.description' => 'Easily convert kibibits (Kibit) to bits (b).',
    'tools.kibibits_to_bits.meta_keywords' => '',
    'tools.kibibits_to_bits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_nibbles.name' => 'Kibibits to Bits',
    'tools.kibibits_to_nibbles.description' => 'Easily convert kibibits (Kibitbit) to nibbles.',
    'tools.kibibits_to_nibbles.meta_keywords' => '',
    'tools.kibibits_to_nibbles.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_bytes.name' => 'Kibibits to Bytes',
    'tools.kibibits_to_bytes.description' => 'Easily convert kibibits (Kibit) to bytes (B).',
    'tools.kibibits_to_bytes.meta_keywords' => '',
    'tools.kibibits_to_bytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_kilobits.name' => 'Kibibits to Kilobits',
    'tools.kibibits_to_kilobits.description' => 'Easily convert kibibits (Kibit) to kilobits (kbit).',
    'tools.kibibits_to_kilobits.meta_keywords' => '',
    'tools.kibibits_to_kilobits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_kilobytes.name' => 'Kibibits to Kilobytes',
    'tools.kibibits_to_kilobytes.description' => 'Easily convert kibibits (Kibit) to kilobytes (kB).',
    'tools.kibibits_to_kilobytes.meta_keywords' => '',
    'tools.kibibits_to_kilobytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_kibibytes.name' => 'Kibibits to Kibibytes',
    'tools.kibibits_to_kibibytes.description' => 'Easily convert kibibits (Kibit) to kibibytes (KiB).',
    'tools.kibibits_to_kibibytes.meta_keywords' => '',
    'tools.kibibits_to_kibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_megabits.name' => 'Kibibits to Megabits',
    'tools.kibibits_to_megabits.description' => 'Easily convert kibibits (Kibit) to megabits (Mbit).',
    'tools.kibibits_to_megabits.meta_keywords' => '',
    'tools.kibibits_to_megabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_mebibits.name' => 'Kibibits to Mebibits',
    'tools.kibibits_to_mebibits.description' => 'Easily convert kibibits (Kibit) to mebibits (Mibit).',
    'tools.kibibits_to_mebibits.meta_keywords' => '',
    'tools.kibibits_to_mebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_megabytes.name' => 'Kibibits to Megabytes',
    'tools.kibibits_to_megabytes.description' => 'Easily convert kibibits (Kibit) to megabytes (MB).',
    'tools.kibibits_to_megabytes.meta_keywords' => '',
    'tools.kibibits_to_megabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_mebibytes.name' => 'Kibibits to Mebibytes',
    'tools.kibibits_to_mebibytes.description' => 'Easily convert kibibits (Kibit) to mebibytes (MiB).',
    'tools.kibibits_to_mebibytes.meta_keywords' => '',
    'tools.kibibits_to_mebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_gigabits.name' => 'Kibibits to Gigabits',
    'tools.kibibits_to_gigabits.description' => 'Easily convert kibibits (Kibit) to gigabits (Gbit).',
    'tools.kibibits_to_gigabits.meta_keywords' => '',
    'tools.kibibits_to_gigabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_gibibits.name' => 'Kibibits to Gibibits',
    'tools.kibibits_to_gibibits.description' => 'Easily convert kibibits (Kibit) to gibibits (Gibit).',
    'tools.kibibits_to_gibibits.meta_keywords' => '',
    'tools.kibibits_to_gibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_gigabytes.name' => 'Kibibits to Gigabytes',
    'tools.kibibits_to_gigabytes.description' => 'Easily convert kibibits (Kibit) to gigabytes (GB).',
    'tools.kibibits_to_gigabytes.meta_keywords' => '',
    'tools.kibibits_to_gigabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_gibibytes.name' => 'Kibibits to Gibibytes',
    'tools.kibibits_to_gibibytes.description' => 'Easily convert kibibits (Kibit) to gibibytes (GiB).',
    'tools.kibibits_to_gibibytes.meta_keywords' => '',
    'tools.kibibits_to_gibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_terabits.name' => 'Kibibits to Terabits',
    'tools.kibibits_to_terabits.description' => 'Easily convert kibibits (Kibit) to terabits (Tbit).',
    'tools.kibibits_to_terabits.meta_keywords' => '',
    'tools.kibibits_to_terabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_tebibits.name' => 'Kibibits to Tebibits',
    'tools.kibibits_to_tebibits.description' => 'Easily convert kibibits (Kibit) to tebibits (Tibit).',
    'tools.kibibits_to_tebibits.meta_keywords' => '',
    'tools.kibibits_to_tebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_terabytes.name' => 'Kibibits to Terabytes',
    'tools.kibibits_to_terabytes.description' => 'Easily convert kibibits (Kibit) to terabytes (TB).',
    'tools.kibibits_to_terabytes.meta_keywords' => '',
    'tools.kibibits_to_terabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_tebibytes.name' => 'Kibibits to Tebibytes',
    'tools.kibibits_to_tebibytes.description' => 'Easily convert kibibits (Kibit) to tebibytes (TiB).',
    'tools.kibibits_to_tebibytes.meta_keywords' => '',
    'tools.kibibits_to_tebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_petabits.name' => 'Kibibits to Petabits',
    'tools.kibibits_to_petabits.description' => 'Easily convert kibibits (Kibit) to petabits (Pbit).',
    'tools.kibibits_to_petabits.meta_keywords' => '',
    'tools.kibibits_to_petabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_pebibits.name' => 'Kibibits to Pebibits',
    'tools.kibibits_to_pebibits.description' => 'Easily convert kibibits (Kibit) to pebibits (Pibit).',
    'tools.kibibits_to_pebibits.meta_keywords' => '',
    'tools.kibibits_to_pebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_petabytes.name' => 'Kibibits to Petabytes',
    'tools.kibibits_to_petabytes.description' => 'Easily convert kibibits (Kibit) to petabytes (PB).',
    'tools.kibibits_to_petabytes.meta_keywords' => '',
    'tools.kibibits_to_petabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_pebibytes.name' => 'Kibibits to Pebibytes',
    'tools.kibibits_to_pebibytes.description' => 'Easily convert kibibits (Kibit) to pebibytes (PiB).',
    'tools.kibibits_to_pebibytes.meta_keywords' => '',
    'tools.kibibits_to_pebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_exabits.name' => 'Kibibits to Exabits',
    'tools.kibibits_to_exabits.description' => 'Easily convert kibibits (Kibit) to exabits (Ebit).',
    'tools.kibibits_to_exabits.meta_keywords' => '',
    'tools.kibibits_to_exabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_exbibits.name' => 'Kibibits to Exbibits',
    'tools.kibibits_to_exbibits.description' => 'Easily convert kibibits (Kibit) to exbibits (Eibit).',
    'tools.kibibits_to_exbibits.meta_keywords' => '',
    'tools.kibibits_to_exbibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_exabytes.name' => 'Kibibits to Exabytes',
    'tools.kibibits_to_exabytes.description' => 'Easily convert kibibits (Kibit) to exabytes (EB).',
    'tools.kibibits_to_exabytes.meta_keywords' => '',
    'tools.kibibits_to_exabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_exbibytes.name' => 'Kibibits to Exbibytes',
    'tools.kibibits_to_exbibytes.description' => 'Easily convert kibibits (Kibit) to exbibytes (EiB).',
    'tools.kibibits_to_exbibytes.meta_keywords' => '',
    'tools.kibibits_to_exbibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_zettabits.name' => 'Kibibits to Zettabits',
    'tools.kibibits_to_zettabits.description' => 'Easily convert kibibits (Kibit) to zettabits (Zbit).',
    'tools.kibibits_to_zettabits.meta_keywords' => '',
    'tools.kibibits_to_zettabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_zebibits.name' => 'Kibibits to Zebibits',
    'tools.kibibits_to_zebibits.description' => 'Easily convert kibibits (Kibit) to zebibits (Zibit).',
    'tools.kibibits_to_zebibits.meta_keywords' => '',
    'tools.kibibits_to_zebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_zettabytes.name' => 'Kibibits to Zettabytes',
    'tools.kibibits_to_zettabytes.description' => 'Easily convert kibibits (Kibit) to zettabytes (ZB).',
    'tools.kibibits_to_zettabytes.meta_keywords' => '',
    'tools.kibibits_to_zettabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_zebibytes.name' => 'Kibibits to Zebibytes',
    'tools.kibibits_to_zebibytes.description' => 'Easily convert kibibits (Kibit) to zebibytes (ZiB).',
    'tools.kibibits_to_zebibytes.meta_keywords' => '',
    'tools.kibibits_to_zebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_yottabits.name' => 'Kibibits to Yottabits',
    'tools.kibibits_to_yottabits.description' => 'Easily convert kibibits (Kibit) to yottabits (Ybit).',
    'tools.kibibits_to_yottabits.meta_keywords' => '',
    'tools.kibibits_to_yottabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_yobibits.name' => 'Kibibits to Yobibits',
    'tools.kibibits_to_yobibits.description' => 'Easily convert kibibits (Kibit) to yobibits (Yibit).',
    'tools.kibibits_to_yobibits.meta_keywords' => '',
    'tools.kibibits_to_yobibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_yottabytes.name' => 'Kibibits to Yottabytes',
    'tools.kibibits_to_yottabytes.description' => 'Easily convert kibibits (Kibit) to yottabytes (YB).',
    'tools.kibibits_to_yottabytes.meta_keywords' => '',
    'tools.kibibits_to_yottabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kibibits_to_yobibytes.name' => 'Kibibits to Yobibytes',
    'tools.kibibits_to_yobibytes.description' => 'Easily convert kibibits (Kibit) to yobibytes (YiB).',
    'tools.kibibits_to_yobibytes.meta_keywords' => '',
    'tools.kibibits_to_yobibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_bits.name' => 'Kilobytes to Bits',
    'tools.kilobytes_to_bits.description' => 'Easily convert kilobytes (kB) to bits (b).',
    'tools.kilobytes_to_bits.meta_keywords' => '',
    'tools.kilobytes_to_bits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_nibbles.name' => 'Kilobytes to Bits',
    'tools.kilobytes_to_nibbles.description' => 'Easily convert kilobytes (kB) to nibbles.',
    'tools.kilobytes_to_nibbles.meta_keywords' => '',
    'tools.kilobytes_to_nibbles.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_bytes.name' => 'Kilobytes to Bytes',
    'tools.kilobytes_to_bytes.description' => 'Easily convert kilobytes (kB) to bytes (B).',
    'tools.kilobytes_to_bytes.meta_keywords' => '',
    'tools.kilobytes_to_bytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_kilobits.name' => 'Kilobytes to Kilobits',
    'tools.kilobytes_to_kilobits.description' => 'Easily convert kilobytes (kB) to kilobits (kbit).',
    'tools.kilobytes_to_kilobits.meta_keywords' => '',
    'tools.kilobytes_to_kilobits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_kibibits.name' => 'Kilobytes to Kibibits',
    'tools.kilobytes_to_kibibits.description' => 'Easily convert kilobytes (kB) to kibibits (Kibit).',
    'tools.kilobytes_to_kibibits.meta_keywords' => '',
    'tools.kilobytes_to_kibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_kibibytes.name' => 'Kilobytes to Kibibytes',
    'tools.kilobytes_to_kibibytes.description' => 'Easily convert kilobytes (kB) to kibibytes (KiB).',
    'tools.kilobytes_to_kibibytes.meta_keywords' => '',
    'tools.kilobytes_to_kibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_megabits.name' => 'Kilobytes to Megabits',
    'tools.kilobytes_to_megabits.description' => 'Easily convert kilobytes (kB) to megabits (Mbit).',
    'tools.kilobytes_to_megabits.meta_keywords' => '',
    'tools.kilobytes_to_megabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_mebibits.name' => 'Kilobytes to Mebibits',
    'tools.kilobytes_to_mebibits.description' => 'Easily convert kilobytes (kB) to mebibits (Mibit).',
    'tools.kilobytes_to_mebibits.meta_keywords' => '',
    'tools.kilobytes_to_mebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_megabytes.name' => 'Kilobytes to Megabytes',
    'tools.kilobytes_to_megabytes.description' => 'Easily convert kilobytes (kB) to megabytes (MB).',
    'tools.kilobytes_to_megabytes.meta_keywords' => '',
    'tools.kilobytes_to_megabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_mebibytes.name' => 'Kilobytes to Mebibytes',
    'tools.kilobytes_to_mebibytes.description' => 'Easily convert kilobytes (kB) to mebibytes (MiB).',
    'tools.kilobytes_to_mebibytes.meta_keywords' => '',
    'tools.kilobytes_to_mebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_gigabits.name' => 'Kilobytes to Gigabits',
    'tools.kilobytes_to_gigabits.description' => 'Easily convert kilobytes (kB) to gigabits (Gbit).',
    'tools.kilobytes_to_gigabits.meta_keywords' => '',
    'tools.kilobytes_to_gigabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_gibibits.name' => 'Kilobytes to Gibibits',
    'tools.kilobytes_to_gibibits.description' => 'Easily convert kilobytes (kB) to gibibits (Gibit).',
    'tools.kilobytes_to_gibibits.meta_keywords' => '',
    'tools.kilobytes_to_gibibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_gigabytes.name' => 'Kilobytes to Gigabytes',
    'tools.kilobytes_to_gigabytes.description' => 'Easily convert kilobytes (kB) to gigabytes (GB).',
    'tools.kilobytes_to_gigabytes.meta_keywords' => '',
    'tools.kilobytes_to_gigabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_gibibytes.name' => 'Kilobytes to Gibibytes',
    'tools.kilobytes_to_gibibytes.description' => 'Easily convert kilobytes (kB) to gibibytes (GiB).',
    'tools.kilobytes_to_gibibytes.meta_keywords' => '',
    'tools.kilobytes_to_gibibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_terabits.name' => 'Kilobytes to Terabits',
    'tools.kilobytes_to_terabits.description' => 'Easily convert kilobytes (kB) to terabits (Tbit).',
    'tools.kilobytes_to_terabits.meta_keywords' => '',
    'tools.kilobytes_to_terabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_tebibits.name' => 'Kilobytes to Tebibits',
    'tools.kilobytes_to_tebibits.description' => 'Easily convert kilobytes (kB) to tebibits (Tibit).',
    'tools.kilobytes_to_tebibits.meta_keywords' => '',
    'tools.kilobytes_to_tebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_terabytes.name' => 'Kilobytes to Terabytes',
    'tools.kilobytes_to_terabytes.description' => 'Easily convert kilobytes (kB) to terabytes (TB).',
    'tools.kilobytes_to_terabytes.meta_keywords' => '',
    'tools.kilobytes_to_terabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_tebibytes.name' => 'Kilobytes to Tebibytes',
    'tools.kilobytes_to_tebibytes.description' => 'Easily convert kilobytes (kB) to tebibytes (TiB).',
    'tools.kilobytes_to_tebibytes.meta_keywords' => '',
    'tools.kilobytes_to_tebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_petabits.name' => 'Kilobytes to Petabits',
    'tools.kilobytes_to_petabits.description' => 'Easily convert kilobytes (kB) to petabits (Pbit).',
    'tools.kilobytes_to_petabits.meta_keywords' => '',
    'tools.kilobytes_to_petabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_pebibits.name' => 'Kilobytes to Pebibits',
    'tools.kilobytes_to_pebibits.description' => 'Easily convert kilobytes (kB) to pebibits (Pibit).',
    'tools.kilobytes_to_pebibits.meta_keywords' => '',
    'tools.kilobytes_to_pebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_petabytes.name' => 'Kilobytes to Petabytes',
    'tools.kilobytes_to_petabytes.description' => 'Easily convert kilobytes (kB) to petabytes (PB).',
    'tools.kilobytes_to_petabytes.meta_keywords' => '',
    'tools.kilobytes_to_petabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_pebibytes.name' => 'Kilobytes to Pebibytes',
    'tools.kilobytes_to_pebibytes.description' => 'Easily convert kilobytes (kB) to pebibytes (PiB).',
    'tools.kilobytes_to_pebibytes.meta_keywords' => '',
    'tools.kilobytes_to_pebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_exabits.name' => 'Kilobytes to Exabits',
    'tools.kilobytes_to_exabits.description' => 'Easily convert kilobytes (kB) to exabits (Ebit).',
    'tools.kilobytes_to_exabits.meta_keywords' => '',
    'tools.kilobytes_to_exabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_exbibits.name' => 'Kilobytes to Exbibits',
    'tools.kilobytes_to_exbibits.description' => 'Easily convert kilobytes (kB) to exbibits (Eibit).',
    'tools.kilobytes_to_exbibits.meta_keywords' => '',
    'tools.kilobytes_to_exbibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_exabytes.name' => 'Kilobytes to Exabytes',
    'tools.kilobytes_to_exabytes.description' => 'Easily convert kilobytes (kB) to exabytes (EB).',
    'tools.kilobytes_to_exabytes.meta_keywords' => '',
    'tools.kilobytes_to_exabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_exbibytes.name' => 'Kilobytes to Exbibytes',
    'tools.kilobytes_to_exbibytes.description' => 'Easily convert kilobytes (kB) to exbibytes (EiB).',
    'tools.kilobytes_to_exbibytes.meta_keywords' => '',
    'tools.kilobytes_to_exbibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_zettabits.name' => 'Kilobytes to Zettabits',
    'tools.kilobytes_to_zettabits.description' => 'Easily convert kilobytes (kB) to zettabits (Zbit).',
    'tools.kilobytes_to_zettabits.meta_keywords' => '',
    'tools.kilobytes_to_zettabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_zebibits.name' => 'Kilobytes to Zebibits',
    'tools.kilobytes_to_zebibits.description' => 'Easily convert kilobytes (kB) to zebibits (Zibit).',
    'tools.kilobytes_to_zebibits.meta_keywords' => '',
    'tools.kilobytes_to_zebibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_zettabytes.name' => 'Kilobytes to Zettabytes',
    'tools.kilobytes_to_zettabytes.description' => 'Easily convert kilobytes (kB) to zettabytes (ZB).',
    'tools.kilobytes_to_zettabytes.meta_keywords' => '',
    'tools.kilobytes_to_zettabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_zebibytes.name' => 'Kilobytes to Zebibytes',
    'tools.kilobytes_to_zebibytes.description' => 'Easily convert kilobytes (kB) to zebibytes (ZiB).',
    'tools.kilobytes_to_zebibytes.meta_keywords' => '',
    'tools.kilobytes_to_zebibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_yottabits.name' => 'Kilobytes to Yottabits',
    'tools.kilobytes_to_yottabits.description' => 'Easily convert kilobytes (kB) to yottabits (Ybit).',
    'tools.kilobytes_to_yottabits.meta_keywords' => '',
    'tools.kilobytes_to_yottabits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_yobibits.name' => 'Kilobytes to Yobibits',
    'tools.kilobytes_to_yobibits.description' => 'Easily convert kilobytes (kB) to yobibits (Yibit).',
    'tools.kilobytes_to_yobibits.meta_keywords' => '',
    'tools.kilobytes_to_yobibits.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_yottabytes.name' => 'Kilobytes to Yottabytes',
    'tools.kilobytes_to_yottabytes.description' => 'Easily convert kilobytes (kB) to yottabytes (YB).',
    'tools.kilobytes_to_yottabytes.meta_keywords' => '',
    'tools.kilobytes_to_yottabytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',

    'tools.kilobytes_to_yobibytes.name' => 'Kilobytes to Yobibytes',
    'tools.kilobytes_to_yobibytes.description' => 'Easily convert kilobytes (kB) to yobibytes (YiB).',
    'tools.kilobytes_to_yobibytes.meta_keywords' => '',
    'tools.kilobytes_to_yobibytes.extra_content' => 'Additional page content, editable from the admin panel -> languages page.',
];
